s        iC   - `                                       mxOX9000    Metrix SCOPIX IV 2.5 GS/s (VISA)                ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]    ViUInt16    ViUInt32  f    This instrument module provides programming support for the Metrix OX9000 DSO 2.5GS/s (VISA).  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Data Functions: (Class)
This class of functions transfers data to or from the instrument.

(6) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
    #    This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

Functions:

(1) Example:
This function configures the OX7000, runs a Single acquisition, reads and displays a waveform.        This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions/SubClasses:

(1) Vertical Setup:
Configures various vertical control parameters.

(2) Horizontal: (SubClass)
Configures horizontal control parameters.

(3) Trigger: (SubClass)
Configures the triggering system of the oscilloscope.

(4) Display: (SubClass)
Configures the display parameters.

(5) Hardcopy Setup:
Configures the hardcopy parameters.
         This class of functions configures the horizontal parameters.

Functions:

(1) Horizontal Setup:
Configures the Horizontal Setup parameters.

(2) Horizontal Display:
Configures the Horizontal Display parameters.

(3)FFT: 
Configures the FFT parameters.
        This class of functions configures the triggering of the oscilloscope.

Functions:

(1) General Trigger :
Configures the edge trigger parameters.

(2) Pulse Trigger:
Configures the pulse trigger parameters.

(3) Delay Trigger:
Configures the delay trigger parameters.

(4) Count Trigger:
Configures the count trigger parameters.

(5) Video Trigger:
Configures the video trigger parameters.
        This class of functions configures the display of the oscilloscope.

Functions:

(1) Options :
Configures the optional display parameters.

(2) Waveform:
Configures the waveform display parameters.

(3) Cursors:
Configures the cursors display parameters.

    ;    This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions:

(1) Autoset:
Performs an autoset.

(2) Run/Stop :
Enables or disables the acquisition of input signals.

(3) Hardcopy :
Performs a harcopy.
        This class of functions transfers data to or from the instrument.

Functions:

(1) Read Cursors:
This function reads the cursors positions.

(2) Read Measurements:
This function reads one of the automatic measurement of the oscilloscope.

(3) Waveform:  (Subclass)
This class of functions transfers waveform data to or from the instrument.

(4) Transfer:  (Subclass)
This class of functions transfers files to or from the instrument.
        This class of functions transfer waveform data to or from the instrument.

Functions:

(1) Read Channel to Array:
Reads a trace from the instrument and places it in an array.

(2) Read Channel to File:
Reads a trace from the instrument and places it in a file.

(3) Read File to Array:
Reads a file and places it in an array.

(4) Write File to Memory:
Writes a waveform saved as a file to an instrument display memory.

    -    This class of functions transfer files to or from the instrument.

Functions:

(1) Save/Recall Setup to/from File:
Saves a setup to a file or recalls a setup from a file.

(2) File transfer:
Tranfers any file from any drive (computer or OX7000 memory) to any other drive (computer or OX7000 memory).    W    This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(2) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(3) Reset:
This function resets the instrument to its default state.

(4) Self-Test:
This function runs the instrument self test and returns the test code.

(5) Error Query:
This function reads an error code from the instrument error queue.

(6) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(7) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.
        This class of functions allows to use the meter mode.

Functions:

(1) MeterConfig:
This function configures the meter mode of the instrument.

(2) Read MeterMeas:
This function forces the instrument in the meter mode to perform selected measurement and returns the result.
        This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Sends initialization commands to the instrument that set any necessary programmatic variables such as Headers Off, Short Command form, and Data Transfer Binary to the state necessary for the operation of the instrument driver.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
    !    This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "USB"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
USB         USB
TCPIP       TCPIP[board]::host address::23::SOCKET



The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
board                       0
host address                IP address        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.

BFFC0011  Instrument returned invalid response to ID Query

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.    H /         Resource Name                     q )        ID Query                              }    Instrument Handle                  #      Status                           X                                             "USB"  ! Do Query VI_ON Skip Query VI_OFF    	           	           UTCPIP Parameters : 
Board = 0
Port = 23

Example : "TCPIP0::192.168.0.3::23::SOCKET"   }    This function is an example of this driver's functions use.

The instrument is set to the single shot mode.
User can change the source channel, the timebase, the input voltage range and the input coupling.
A trigger is then sent to the instrument.
The function waits until the acquisition is completed.
Channel is read out from the instrument.
Waveform is interpolated if needed.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Channel) out of range.
BFFC0003  Parameter 3 (Timebase) out of range.
BFFC0004  Parameter 4 (Voltage Range) out of range.
BFFC0005  Parameter 5 (Coupling) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     m    This control selects the source channel.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
2 - CH3  
3 - CH4     x    This control selects the input coupling of the selected channel.

Valid Values:
0 - AC  (Default Value)
1 - DC
2 - GND    o    This control sets vertical sense for the specified channel. 

Valid Values:

0  - 2mV/div 
1  - 5mV/div  
2  - 10mV/div           
3  - 20mV/div           
4  - 50mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div           
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  (Default Value)
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            

Note : This control value must be consistent with the probe value. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER7 (0xBFFC0907)


         This control specifies the name of the array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.     R    This control returns the number of valid points read from the selected channel.
     i    This control returns the time of the first data point in seconds (with respect to the trigger point).

     I    This control returns the incrementing value in seconds for the X axis.
        This control selects the main timebase  value.

Valid Values:
0  - 1 ns
1  - 2 ns 
2  - 5 ns
3  - 10 ns  
4  - 25 ns 
5  - 50 ns
6  - 100 ns  
7  - 200 ns
8  - 500 ns - (Default Value)
9  - 1 s  
10 - 2 s
11 - 4 s
12 - 10 s  
13 - 20 s 
14 - 50 s
15 - 100 s  
16 - 200 s 
17 - 500 s 
18 - 1 ms  
19 - 2 ms  
20 - 5 ms 
21 - 10 ms   
22 - 20 ms 
23 - 40 ms 
24 - 100 ms   
25 - 200 ms  
26 - 500 ms 
27 - 1 s  
28 - 2 s
29 - 5 s
30 - 10 s  
31 - 20 s
32 - 50 s
33 - 100 s
34 - 200 s    (#      Status                            -]#         Instrument Handle                 - ) G        Source                            .q )  P    Coupling                          . )  P    Voltage Range                     1h     `    Waveform Array                    2     `    Number of samples                 2l ,   `    X Start                           2    `    X Increment                       3. 4   P    Timebase                           	                          CH1 0 CH2 1 CH3 2 CH4 3              AC 0 DC 1 GND 2        	      200 V 15 100 V 14 50 V 13 20 V 12 10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50 mV 4 20 mV 3 10 mV 2 5 mV 1 2 .5 mV 0    	            	            	           	                  #  (200 s 34 100 s 33 50 s 32 20 s 31 10 s 30 5 s 29 2 s 28 1 s 27 500 ms 26 200 ms 25 100 ms 24 40 ms 23 20 ms 22 10 ms 21 5 ms 20 2 ms 19 1 ms 18 500 s 17 200 s 16 100 s 15 50 s 14 20 s 13 10 s 12 4 s 11 2 s 10 1 s 9 500 ns 8 200 ns 7 100 ns 6 50 ns 5 25 ns 4 10 ns 3 5 ns 2 2 ns 1 1 ns 0        This function configures the selected input channel of the instrument.

The following settings are available :
- Channel
- State
- Coupling
- Probe
- Range
- Offset
- Bandwidth limitation    '    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Input) out of range.
BFFC0003  Parameter 3 (State) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Probe) out of range.
BFFC0006  Parameter 6 (Volts/div) out of range.
BFFC0007  Parameter 7 (Offset) out of range.
BFFC0008  Parameter 8 (Bandwidth) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     u    This control selects the channel to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3
4 - CH4
  
     y    This control selects the coupling of the specified channel.

Valid Values: 
0 - AC  
1 - DC  (Default Value)
2 - GND  
     z    This control selects the probe of the specified channel.

Valid Values: 
1 - x 1  (Default Value)
10 - x 10
100- x 100 
    {    This control sets vertical sense for the specified channel. 

Valid Values:

0  - 2.50mV/div 
1  - 5.00mV/div  
2  - 10.0mV/div           
3  - 20.0mV/div           
4  - 50.0mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div     (Default Value)      
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            

Note : This control value must be consistent with the probe value. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER7 (0xBFFC0907)


    c    This control sets the signal offset of the specified channel. 

Valid Ranges:

vertical sense       offset range
2.5mV/div            +/- 25mV
5mV/div              +/- 50mV
10mV/div             +/- 100mV
20mV/div             +/- 200mV
50mV/div             +/- 500mV
100mV/div            +/- 1V
200mV/div            +/- 2V
500mV/div            +/- 5V
1V/div               +/- 10V
2V/div               +/- 20V
5V/div               +/- 50V
10V/div              +/- 100V
20V/div              +/- 200V
50V/div              +/- 500V
100V/div             +/- 1000V
200V/div             +/- 2000V

Default Value: 0.0
         This control selects the state of the specified channel.

Valid Values: 
OFF     (0)   (Default Value)
15 MHz  (1) 
1.5 MHz (2) 
5 kHz   (3) 
     }    This control selects the state of the specified channel.

Valid Values: 
VI_ON  (1) - On  (Default Value)
VI_OFF (0) - Off
    :F#      Status                            ?u#         Instrument Handle                 @ ) G        Input                             @ )        Coupling                          A )}        Probe                             A  d  K    Volt/Div                          D    K    Offset (volts)                    F         Bandwidth                         G )         State                              	                          CH1 1 CH2 2 CH3 3 CH4 4              AC 0 DC 1 GND 2               x1 1 x10 10 x100 100              200 V 15 100 V 14 50 V 13 20 V 12 10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50.0 mV 4 20.0 mV 3 10.0 mV 2 5 .00mV 1 2.50 mV 0    0.0               !OFF 0 15 MHz 1 1.5 MHz 2 5 kHz 3   On VI_ON Off VI_OFF        This function configures the horizontal settings of the instrument.

The following settings are available :

- Pretrigger 
- Range (the main timebase)

    A    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Range) out of range.
BFFC0003  Parameter 3 (Pretrig) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control selects the main timebase  value.

Valid Values:
0  - 1 ns
1  - 2 ns 
2  - 5 ns
3  - 10 ns  
4  - 25 ns 
5  - 50 ns
6  - 100 ns  
7  - 200 ns
8  - 500 ns - (Default Value)
9  - 1 s  
10 - 2 s
11 - 4 s
12 - 10 s  
13 - 20 s 
14 - 50 s
15 - 100 s  
16 - 200 s 
17 - 500 s 
18 - 1 ms  
19 - 2 ms  
20 - 5 ms 
21 - 10 ms   
22 - 20 ms 
23 - 40 ms 
24 - 100 ms   
25 - 200 ms  
26 - 500 ms 
27 - 1 s  
28 - 2 s
29 - 5 s
30 - 10 s  
31 - 20 s
32 - 50 s
33 - 100 s
34 - 200 s         This control selects the pretrig value ().

Default Value: -2500.0

Valid Values are between 0 and -4640.0

    0 : on the left of the display
-2500 : on the middle of the display
-4640 : on the right of the display
        K#      Status                            O#         Instrument Handle                 Pg V >  P    Range                             R[ X  `    Pretigg value                      	                      #  (200 s 34 100 s 33 50 s 32 20 s 31 10 s 30 5 s 29 2 s 28 1 s 27 500 ms 26 200 ms 25 100 ms 24 40 ms 23 20 ms 22 10 ms 21 5 ms 20 2 ms 19 1 ms 18 500 s 17 200 s 16 100 s 15 50 s 14 20 s 13 10 s 12 4 s 11 2 s 10 1 s 9 500 ns 8 200 ns 7 100 ns 6 50 ns 5 25 ns 4 10 ns 3 5 ns 2 2 ns 1 1 ns 0    -2500        This function configures the horizontal display of the instrument.
 
The following settings are available :

- Trace 
- X (for XY mode)
- Y (for XY mode)

         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    c    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trace) out of range.
BFFC0003  Parameter 3 (X) out of range.
BFFC0004  Parameter 4 (Y) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     l    This control selects the traces to be displayed.

Valid Values: 
0 - Oscilloscope  (Default Value)
1 - XY
     k    This control selects the X input for XY mode.

Valid Values: 
1 - 1  (Default Value)
2 - 2  
3 - 3
4 - 4
     j    This control selects the Y input for XY mode.

Valid Values: 
1 - 1  (Default Value)
2 - 2  
3 - 3
4 - 4    V
#         Instrument Handle                 V#      Status                            [ >        Trace                             [  n        X                                 [         Y                                      	                      Oscilloscope 0 XY 1               1 1 2 2 3 3 4 4               1 1 2 2 3 3 4 4    w    This function configures the FFT mode.

The following settings are available :

- FFT ON or OFF 
- Calculate
- Scale
         This control selects the calculate mode.

Valid Values: 
0 - Rectangular  (Default Value)
1 - Hamming
2 - Hanning  
3 - Blackman         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    m    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (FFT) out of range.
BFFC0003  Parameter 3 (Calculate) out of range.
BFFC0004  Parameter 4 (Scale) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     w    This control selects the Scale.

Valid Values: 
VI_ON  (1) - Log scale   (Default Value)
VI_OFF (0) - Linear scale  
     e    This control valid the FFT mode.

Valid Values: 
VI_OFF (0) - OFF  (Default Value)
VI_ON  (1) - ON
    ^f          Calculate                         ^#         Instrument Handle                 _#      Status                            d p        Scale                             d 5         FFT                                           -Rectangular 0 Hamming 1 Hanning 2 Blackman 3        	         $ Log Scale VI_ON Linear scale VI_OFF    ON VI_ON OFF VI_OFF        This function configures the general trigger parameters of the instrument.

The following settings are available :

- Trigger Source 
- Slope
- Coupling
- Noise Rejection
- Type
- Level
- Holdoff

    +    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Slope) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Noise Rejection) out of range.
BFFC0006  Parameter 6 (Type) out of range.
BFFC0007  Parameter 7 (Level) out of range.
BFFC0008  Parameter 8 (Holdoff) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     x    This control selects the trigger source to configure.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
2 - CH3
3 - CH4     |    This control sets the slope of the specified channel.

Valid Values: 
VI_ON  (1) - Up (Default Value)
VI_OFF (0) - Down  
         This control selects the coupling mode of the specified channel.

Valid Values: 
0 - AC (Default Value)
1 - DC  
2 - LF Rej
3 - HF Rej
         This control sets level of trigger for the specified channel. 

Valid Range:
-8 * vertSense (vertSense in Volts/div)  to  8 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
     ]    This control sets the holdoff value. 

Valid Range:
64.0 ns to 15s

Default Value: 64.0 ns
     p    This control selects the type of trigger.

Valid Values: 
0 - Triggered
1 - Auto (Default Value)
2 - Single  
     t    This control sets the noise rejection of the specified channel.

Valid Values: 
0 - OFF  (Default Value)
3 - ON  
    gR#      Status                            l#         Instrument Handle                 m$ ) 9        Trigger Source                    m )         Slope                             n( )T        Coupling                          n    `    Level (volts)                     oz   `    Holdoff (seconds)                 o  >        Type                              pW .        Noise Rejection                    	                          CH1 0 CH2 1 CH3 2 CH4 3   Up VI_ON Down VI_OFF               AC 0 DC 1 LF rej 2 HF rej 3    0.0    64e-9              Trig'd 0 Auto 1 Single 2              ON 3 OFF 0        This function configures the pulsate trigger mode of the instrument.

The following settings are available :

- Trigger pulsate type
- Pulse
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    e    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Type) out of range.
BFFC0003  Parameter 3 (T1) out of range.
BFFC0004  Parameter 4 (T2) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the trigger pulsate type.

Valid Values: 
0 - T < T2  (Default Value)
1 - T > T1
2 - T > T1 and T < T2 
3 - T < T1 or T > T2

     b    This control sets the durate  of the pulse. 

Valid Values:
16ns   to  15s 
Default Value: 16ns
     a    This control sets the durate  of the pulse. 

Valid Values:
16ns   to  15s 
Default Value: 15s
    t#         Instrument Handle                 t#      Status                            y G         Trigger Pulsate type              y W  `    T1                                z&   `    T2                                     	                      9T < T2 0 T > T1 1 T > T1 and T < T2 2 T < T1 or T > T2 3    16E-9    15        This function configures the delayed trigger parameters of the instrument.

The following settings are available :

- Auxiliary Source 
- Edge
- Coupling
- Noise Rejection
- Level
- Delay
- Holdoff
     o    This control selects the auxilary source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4
     d    This control sets the delay value in seconds.

Valid Range:
48 ns  to  20 s

Default Value: 48 ns
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Auxiliary source) out of range.
BFFC0003  Parameter 3 (Edge) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Noise rejection) out of range.
BFFC0006  Parameter 6 (Level) out of range.
BFFC0007  Parameter 7 (Delay) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the coupling mode of the specified channel.

Valid Values: 
0 - AC (Default Value)
1 - DC  
2 - LF Rej
3 - HF Rej

         This control sets level of trigger for the specified channel. 

Valid Range:
-8 * vertSense (vertSense in Volts/div)  to  8 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
     {    This control sets the slope of the specified channel.

Valid Values: 
VI_ON  (1) - Pos (Default Value)
VI_OFF (0) - Neg 
     t    This control sets the noise rejection of the specified channel.

Valid Values: 
0 - OFF  (Default Value)
3 - ON  
    | - L        Auxiliary Source                  }F     `    Delay                             }#         Instrument Handle                 ~Q#      Status                            ` 3        Coupling                            3  `    Level (volts)                      3         Edge                              6 1        Noise Rejection                               CH1 1 CH2 2 CH3 3 CH4 4    48E-9        	                      AC 0 DC 1 LF rej 2 HF rej 3    0.0   Pos VI_ON Neg VI_OFF              ON 3 OFF 0        This function configures the count trigger parameters of the instrument.

The following settings are available :

- Auxiliary Source 
- Edge
- Coupling
- Noise Rejection
- Level
- Events
- Holdoff
     p    This control selects the counter source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4


     _    This control sets the number of events to count.

Valid Range:
3 to 16400 

Default Value: 3
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    7    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Auxiliary source) out of range.
BFFC0003  Parameter 3 (Edge) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Qualifier) out of range.
BFFC0006  Parameter 6 (Noise rejection) out of range.
BFFC0007  Parameter 7 (Level) out of range.
BFFC0008  Parameter 8 (Events) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     |    This control sets the slope of the specified channel.

Valid Values: 
VI_ON  (1) - Pos (Default Value)
VI_OFF (0) - Neg  
         This control selects the coupling mode of the specified channel.

Valid Values: 
0 - AC (Default Value)
1 - DC  
2 - LF Rej
3 - HF Rej

         This control sets level of trigger for the specified channel. 

Valid Range:
-7.5 * vertSense (vertSense in Volts/div)  to  7.5 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
     t    This control sets the noise rejection of the specified channel.

Valid Values: 
0 - OFF  (Default Value)
3 - ON  
     * D        Auxiliary Source                  E P  `    Events                            #         Instrument Handle                 K#      Status                             .         Edge                               -        Coupling                              `    Level (volts)                     e 2        Noise Rejection                               CH1 1 CH2 2 CH3 3 CH4 4    3        	          Pos VI_ON Neg VI_OFF               AC 0 DC 1 LF rej 2 HF rej 3    0.0              ON 3 OFF 0        This function configures the display options of the instrument.

The following settings are available :

- Divice Mode
- Language
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control selects the principal mode.

Valid Values: 
0 - Scope   (Default Value)
1 - Analyser
2 - Recorder 
3 - Multimeter      #      Status                            #         Instrument Handle                 n 5        Device Mode                        	                          0Home 0 Scope 1 Analyser 2 Logger 3 Multimeter 4        This function configures the waveform display of the instrument.

The following settings are available :

- Min/Max acquisition
- Average rate
- Mode 
- Repetitive Signal
     u    This control sets the average rate.

Valid Values: 
0 - No averaging (Default Value)
1 - 2  
2 - 4
3 - 16  
4 - 64
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Min/Max) out of range.
BFFC0003  Parameter 3 (Average rate) out of range.
BFFC0004  Parameter 4 (Display mode) out of range.
BFFC0005  Parameter 5 (Repetitive signal) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     f    This control selects the display mode.

Valid Values: 
0 - Vector   (Default Value)
1 - Envelope
        s    This control selects the repetitive signal.

Valid Values: 
VI_OFF (0) - Off  
VI_ON  (1) - On   (Default Value)
     s    This control Valids the Min/Max Acquisition.

Valid Values: 
1 - Normal_OFF   (Default Value)
0 - Envelope_ ON


     H  Z    Average rate                      #         Instrument Handle                 #      Status                            r 5        Display Mode                                Repetitive Signal                 [ >         Min-Max                                      !64 4 16 3 4 2 2 1 No averaging 0        	                      0Vector 0 Envelope 1 All samples 2 Persistence 3   On VI_ON Off VI_OFF              ON 0 OFF 1    |    This function sets horizontal cursors.

The following settings are available :

- Cursors 
- Reference
- T1
- T2
- TPhase
     g    This control selects the reference.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
2 - CH3
3 - CH4
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Clear Cursors) out of range.
BFFC0003  Parameter 3 (Reference) out of range.
BFFC0004  Parameter 4 (T1) out of range.
BFFC0005  Parameter 5 (T2) out of range.
BFFC0006  Parameter 6 (Tphase) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     v    This control sets the position of the vertical cursor #1.

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

     ~    This control sets the position of the vertical cursor #3 (phase).

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

     Y    This control selects the cursors mode.

Valid Values: 
0 - OFF  (Default Value)
1 - ON
     v    This control sets the position of the vertical cursor #2.

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

    H )S        Reference                         #         Instrument Handle                 V#      Status                            '  Q  `    T1 (s)                                `    Tphase(s)                         + -         Cursors                                `    T2 (s)                                        CH1 0 CH2 1 CH3 2 CH4 3        	           250E-3    250E-3               OFF 0 ON 1    500E-3    6    This function performs an autoset of the instrument.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090F  No channel is enabled.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    *#      Status                            :#         Instrument Handle                  	               D    This function controls the acquisition system of the instrument. 
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Acquisition) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control valid the acquisition system of the instrument. 

Valid Values:
VI_OFF (0) - Stop 
VI_ON  (1) - Run   (Default Value)

    #      Status                            #         Instrument Handle                 _ Y         Acquisition                        	              Run VI_ON Stop VI_OFF    ?    This function controls the hardcopy system of the instrument.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0803  Error scanning response

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    #      Status                            #         Instrument Handle                  	               Z    This function reads cursors positions.
All measured quantities are in their basic units.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    :    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Reference) out of range.
BFFC0003  Parameter 3 (T1) out of range.
BFFC0004  Parameter 4 (T2) out of range.
BFFC0005  Parameter 5 (dT) out of range.
BFFC0006  Parameter 6 (V1) out of range.
BFFC0007  Parameter 7 (V2) out of range.
BFFC0008  Parameter 8 (dV) out of range.
BFFC0009  Parameter 9 (Tphase) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the reference channel for the cursors positions.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
2 - CH3  
3 - CH4     ?    This control outputs the position of the vertical cursor #1.
     ?    This control outputs the position of the vertical cursor #2.
     ?    This control outpus the difference between vertical cursors.
     @    This control outpus the position of the horizontal cursor #1.
     ?    This control outpus the position of the horizontal cursor #2.     A    This control outpus the difference between horizontal cursors.
     :    This control outpus the phase between vertical cursors.
    ?#         Instrument Handle                 #      Status                               7        Reference                         Ʋ     `    T1 (s)                             b    `    T2 (s)                            @     `    dT (s)                            Ǉ \   `    V1 (V)                             bZ   `    V2 (V)                             Y   `    dV (V)                            _     `    Tphase (s)                             	                      CH1 0 CH2 1 CH3 2 CH4 3    	           	           	           	           	           	           	               This function forces the instrument to perform selected measurement and returns the result.
All measured quantities are in their basic units.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    w    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Measurement) out of range.
BFFC0003  Parameter 3 (Reference) out of range.
BFFC0004  Parameter 4 (Reading) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the reference channel for the specified measurement.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
2 - CH3
3 - CH4     n    This control outputs the result of the measurement.
All measured quantities are output in their basic units.        This control specifies the measurement function.

Valid Values: 
0  - Minimum Voltage     [V]  
1  - Maximum Voltage     [V]
2  - Peak to Peak        [V] (Default Value)
3  - Low Voltage         [V]  
4  - High Voltage        [V]
5  - Amplitude           [V]    
6  - Voltage RMS Interval[V]
7  - Voltage RMS Cycle   [V]
8  - Average Voltage     [V] 
9  - SUM                 [Vs] 
10 - Rise Time           [s] 
11 - Fall Time           [s]
12 - Pos Pulse Width     [s]
13 - Neg Pulse Width     [s]
14 - Period              [s] 
15 - Frequency           [Hz]
16 - Dutycycle           [%]
17 - N pulses
18 - Rise Overshoot      [%]
19 - Fall Overshoot      [%] 
    #         Instrument Handle                 t#      Status                             )        Reference                         ч z   `    Reading                             4  x    Measurement                            	                      CH1 0 CH2 1 CH3 2 CH4 3    	                    1Minimun Voltage 0 Maximun  Voltage 1 Peak To Peak 2 Low Voltage 3 High Voltage 4 Amplitude 5 RMS Voltage(AC) 6 RMS Voltage (Cycle) 7 Average Voltage 8 Sum 9 Rise Time 10 Fall Time 11 Pos Pulse Width 12 Neg Pulse Width 13 Period 14 Frequency 15 Duty Cycle 16 N pulses 17 Pos Overshoot  18 Neg Overshoot 19    [    This function reads the specified channel from the instrument and places it in an array.
     l    This control selects the source channel.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
2 - CH3
3 - CH4
         This function specifies the name of array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.His numberr of elements is 2500.
     S    This function returns the number of valid points read from the selected channel.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    V    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     j    This function returns the time of the first data point in seconds (with respect to the trigger point).

     J    This function returns the incrementing value in seconds for the X axis.
    ׋ 3        Source                              
   `    Waveform Array                         `    Number of samples                 "#         Instrument Handle                 #      Status                             +   `    X Start                           ޑ    `    X Increment                                   CH1 0 CH2 1 CH3 2 CH4 3    	            	                	           	           	           M    This function reads a channel from the instrument and stores it as a file.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Drive) out of range.
BFFC0004  Parameter 4 (Filename) out of specifications.
BFFC0005  Parameter 5 (Overwrite File?) out of range.

BFFC0801  Error writing to file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.
BFFC090E  File already exists.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
        This function specifies the name of the wave data file.

Default Value: ""

Notes:

(1) When storing a file to Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 32-character long max with ".trc" extension.
The extention must be in lowercase letter.
If not, an error is generated :0xBFFC0004 

(3) If the target file already exists and overwrite is not selected, an error is generated : 0xBFFC090E

     [    This control selects the destination drive.

Valid Values:
0 - Computer
1 - OX9xxx Memory         This function specifies whether or not to write over the specified file if it already exists.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
     l    This control selects the source channel.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
2 - CH3
3 - CH4
    #         Instrument Handle                 #      Status                                     File Name                                   Drives                            H         Overwrite File?                    5        Source                                 	           ""               Computer 0 OX9xxx Memory 1    Yes VI_ON No VI_OFF               CH1 0 CH2 1 CH3 2 CH4 3    g    This function writes a wave data file (in the memory oscilloscope) to the instrument display memory.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    n    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Filename) out of range.

BFFC0800  Error opening file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
        This control selects the target memory.

Default Value: ""

Notes:

(1) File name must be 32-character long max with ".trc" extension.
The extention must be in lowercase letter.
If not an error is generated :0xBFFC0003  

(2) If file does not exist an error is generated : 0xBFFC090D

    #         Instrument Handle                 0#      Status                             *        File Name                              	           ""    7    This function save or recall set-up to or from file.
    D    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Drive) out of range.
BFFC0004  Parameter 4 (Filename) out of specifications.
BFFC0005  Parameter 5 (Overwrite File?) out of range.

BFFC0800  Error opening file.
BFFC0801  Error writing to file.
BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC090E  File already exists.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     q    This control selects the target/source drive.

Valid Values:
0 - Computer  
1 - OX9xxx Memory  (Default Value)
        This function specifies the name of the setup data file.

Default Value: ""

Notes:

(1) When reading/writing a file from/to Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 32-character long max with ".cfg" extension.
The extention must be in lowercase letter.
If not an error is generated :0xBFFC0004  

(3) When saving a setup : if the target file already exists and overwrite is not selected an error is generated : 0xBFFC090E

(4) When recalling a setup : if file does not exist an error is generated : 0xBFFC090D

         This function specifies whether or not to write over the specified file if it already exists on disk.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
     |    This control selects between Save and Recall mode.

Valid Range:  
VI_OFF (0) - Recall
VI_ON  (1) - Save  (Default Value)
    #      Status                            
#         Instrument Handle                           Drives                            %         File Name                                  Overwrite File?                   o )        Mode                               	                         Computer 0 OX9xxx Memory 1    ""    Yes VI_ON No VI_OFF   Save VI_ON Recall VI_OFF    ,    This function performs a file transfer.


         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Filename) out of specifications.
BFFC0003  Parameter 3 (Source Drive) out of range.
BFFC0004  Parameter 4 (Overwrite File?) out of range.

BFFC0800  Error opening file.
BFFC0801  Error writing to file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC090E  File already exists.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     h    This control selects the source drive.

Valid Values:
0 - Computer  (Default Value)
1 - OX9xxx Memory
    h    This function specifies the name of the data file.

Default Value: ""

Notes:

(1) When reading a file from Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 32-character long max with extension.
The extention must be in lowercase letter.
If not an error is generated :0xBFFC0002  

(3) If the file already exists on the target drive and overwrite is not selected an error is generated : 0xBFFC090E

(4) If file does not exist on the source drive an error is generated : 0xBFFC090D         This function specifies whether or not to write over the specified file if it already exists on disk.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
    #         Instrument Handle                 w#      Status                                     Source Drive                      +        File Name                                 Overwrite File?                        	                      Computer 0 OX9xxx Memory 1    ""    Yes VI_ON No VI_OFF    m    This function writes commands and queries to the instrument to modify parameters and query device settings.    z    The user can use this control to send common commands and queries to the instrument. This control can also be used to write any valid command to the instrument.

Default Value:  "*CLS\r"

Notes:

(1) The command or query to be sent to the instrument may be a literal enclosed in double quotes terminated by '\r' i.e. "*CLS\r" or may be contained in a variable of type string.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    M E      Write Buffer                     #      Status                           -#         Instrument Handle                  	"*CLS\r"    	              7    This function reads data from the instrument's output buffer and returns it to the specified variable in memory.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) If valid data is not available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled this function will hang indefinitely and it may be necessary to reboot the computer to break out.        The number of bytes specified by this control should be greater than or equal to the number of bytes which are to be read from the instrument. If the actual number of bytes to be read is greater than the number this control specifies then multiple reads will be required to empty the instrument's output buffer.

If the instrument's output buffer is not emptied the instrument may return invalid data when future reads are performed.

Default Value:  50 (See NOTE 2)

Notes:

(1) If NO DATA is available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled, this function will hang indefinitely and it may be necessary to reboot the computer.

(2) If the number of bytes expected is greater than 50 the value of this control may be increased. If the actual number of bytes read is larger than the declared size of the read buffer a run-time error will be generated.
        The incoming data from the instrument is placed into this variable.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) This function does not overwrite any old data left in the string variable from the last time the function was called. String data in LabWindows/CVI is terminated with an ASCII null(0x0) and string manipulation functions will only recognize data before the ASCII null.

(3) The declared size of the string variable must be greater than the actual number of bytes read from the instrument if it is not a run-time error will be generated.
        This variable contains the actual number of bytes read from the instrument. This is the value which is returned by the read function.

Notes:

(1) If the actual number of bytes read is less than the number of bytes specified in the Number Bytes To Read control then the output buffer has probably been emptied. If the read function fails and the number of bytes read is 0, the most probable cause for the failure is there was no data available at the instrument's output buffer.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    M K   `    Number Bytes To Read               H      Read Buffer                      C Mx   `    NumBytes Read                    +#      Status                           #         Instrument Handle                  50    	            	            	               ~    This function resets the instrument to a known state.
See the Digiscope 2000 Operating Instructions manual for more details.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   ",#      Status                           %#         Instrument Handle                  	               W    This function runs the instrument's self test routine and returns the test result(s).         This control contains the value returned from the instrument self test.  Zero means success.  For any other code, see the device's operator's manual.
         This control contains the string returned from the self test. See the device's operation manual for an explanation of the string's contents.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0803  Error scanning response.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   'I = 2   `    Self Test Result                 ' =   ,    Self-Test Message                (#      Status                           ,#         Instrument Handle                  	           	            	               H    This function reads an error code from the instrument's error queue.

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   .z = 2   `    Error Code                       . =   ,    Error Message                    /~#      Status                           3##         Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.
3FFF0085  Unknown status.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL   5Q =    `    Error Code                       5 =       Error Message                    6q#      Status                           :0#         Instrument Handle                  0    	            	           VI_NULL   0    This function returns the revision numbers of the instrument driver and instrument firmware, and tells the user what firmware the driver is compatible with, for example:

This instrument driver's Revision Number is "Rev 1.0, 04/2005, CVI 6.0" and is compatible with Instrument Firmware Revision "1.6".
         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   = = 2       Instrument Driver Revision       = =,       Firmware Revision                >#      Status                           A#         Instrument Handle                  	            	            	                   This function configures the meter mode of the instrument.

The following settings are available :
- Input
- Measure
- Coupling
- AutoRange
- VoltRang
- OhmRang
- CapaRang    3    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Input) out of range.
BFFC0003  Parameter 3 (Measurement) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (AutoRange) out of range.
BFFC0006  Parameter 6 (VoltRange) out of range.
BFFC0007  Parameter 7 (OhmRange) out of range.
BFFC0008  Parameter 8 (CapaRange) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     u    This control selects the channel to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3
4 - CH4
  
     z    This command affects the coupling of the selected channel.

Valid Values: 
0 - DC  (Default Value)
1 - AC  
2 - AC+DC  
         The command selects the measurement range to be used in voltmeter mode for the selected channel.

Valid Values:

0  - 800  mV 
1  - 8.00 V  
2  - 80.0 V           
3  - 800  V           
         This command authorizes or prohibits the autoranging of the selected channel.

Valid Values: 
VI_ON  (1) - On  
VI_OFF (0) - Off (Default Value)
         This command selects the measurement function on channel 1.

Valid Values:

0  - Voltage
1  - Resistance 
2  - Continuity
3  - Capacitor  
4  - Diode 
         This command selects the measurement range to be used in ohm-meter mode.

Valid Values:

0  - 80.0 OHM 
1  - 800  OHM  
2  - 8.00 K OHM           
3  - 80.0 K OHM           
4  - 800  K OHM            
5  - 8.00 M OHM          
6  - 32.0 M OHM          
         This selects the range of measurement to be used in capacitance mode.

Valid Values:

0  - 5.00 nF 
1  - 50 nF  
2  - 500 nF           
3  - 5.00 uF           
4  - 50 uF             
5  - 500 uF          
6  - 5.00 mF         
         This command affects the bandwith of the selected channel.

Valid Values: 
0 - None  (Default Value)
1 - < 5 kHz  
2 - < 625 Hz  
   D#      Status                           IK#         Instrument Handle                I ) G        Input                            Jg -_        Coupling                         J    K    VoltRang                         K  1        AutoRange                        LI )   P    Measurement                      L "  K    OhmRang                          M   K    CapaRang                         N -        Bandwith                           	                          CH1 1 CH2 2 CH3 3 CH4 4               DC 0 AC 1 AC+DC 2              800mV 0 8.00 V 1 80V 2 800 V 3   On VI_ON Off VI_OFF               8Voltage 0 Resistance 1 Continuity 2 Capacitor 3 Diode 4               T80.0  OHM 0 800 OHM 1 8.0 k OHM 2 80.0 K OHM 3 800 K OHM 4 8.0 M OHM 5 32.0 M OHM 6              @5.00 nF 0 50 nF 1 500 nF 2 5.00 uF 3 50 uF 4 500 uF 5 5.00 mF 6               None 0 < 5 kHz 1 < 625 Hz 2        This function forces the instrument in the meter mode to perform selected measurement and returns the result.
All measured quantities are in their basic units.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    E    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Reference) out of range.
BFFC0003  Parameter 3 (Reading) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the reference channel for the specified measurement.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3
4 - CH4         This control outputs the result of the main measurement for the selected channel.
All measured quantities are output in their basic units.
   S#         Instrument Handle                T#      Status                           X > `        Reference                        Yh :U   `    Reading                                	                      CH1 1 CH2 2 CH3 3 CH4 4    	               This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   [j      Status                           _f         Instrument Handle                  	                     9  %b     K*    init                                     '  5" 
    K.    example                                  9  G 	    K.    verticalSetup                            J  SA     K.    horizontalSetup                          Ue  \m     K.    horizontalDisplay                        ]  d     K.    FFT                                      f  p 	    K.    setGeneralTrigger                        s|  z     K.    setPulsTrigger                           {       K.    setDelayedTrigger                               K.    setCountTrigger                          )       K.    setOptionDisplay                                K.    setWaveformDisplay                         
     K.    setCursors                                      K.    runAutoset                               S       K.    runAcquisition                             c     K.    runHardcopy                                ȡ 
    K.    readCursors                              >  Ԝ     K.    readMeasurement                          (       K.    readChToArr                                f     K.    readChToFile                             "       K.    writeFileToMem                                  K.    saveSetup                                 	1     K.    fileTransfer                            
      K.    writeInstrData                            o     K.    readInstrData                           ! &p     K.    reset                                   & -.     K.    selfTest                                .* 3     K.    errorQuery                              4 :     K.    errorMessage                            ; B_     K.    revisionQuery                           C[ Ol 
    K.    Meterconfig                             S? Y     K.    readMeterMeas                           [ `     K.    close                                                                      DInitialize                          1Application Functions                DExample                             \Configure Functions                  DVertical Setup                      	:Horizontal                           DHorizontal Setup                     DHorizontal Display                   DFFT                                 
ATrigger                              DGeneral Trigger                      DPulse Trigger                        DDelayed Trigger                      DCount Trigger                       Display                              DOptions                              DWaveform                             DCursors                             Action/Status Functions              DAutoset                              DRun/Stop                             DHardcopy                            Data                                 DRead Cursors                         DRead Measurements                   Waveform                             DRead Channel To Array                DRead Channel To File                 DWrite File To Memory                Transfer                             DSave/Recall Setup To/From File       DFile Transfer                       Utility Functions                    DWrite To Instrument                  DRead Instrument Data                 DReset                                DSelf-Test                            DError-Query                          DError Message                        DRevision Query                      METER                                DMeterConfig                          DRead MeterMeas                       DClose                           