s           1   
                                     mxOX2000    Metrix OX2000 DSO 200MS/s (VISA)                ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]    ViUInt16    ViUInt32  f    This instrument module provides programming support for the Metrix OX2000 DSO 200MS/s (VISA).  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Data Functions: (Class)
This class of functions transfers data to or from the instrument.

(6) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
    #    This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

Functions:

(1) Example:
This function configures the OX2000, runs a Single acquisition, reads and displays a waveform.        This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions/SubClasses:

(1) Vertical Setup:
Configures various vertical control parameters.

(2) Horizontal: (SubClass)
Configures horizontal control parameters.

(3) Trigger: (SubClass)
Configures the triggering system of the oscilloscope.

(4) Display: (SubClass)
Configures the display parameters.

(5) Hardcopy Setup:
Configures the hardcopy parameters.
         This class of functions configures the horizontal parameters.

Functions:

(1) Horizontal Setup:
Configures the Horizontal Setup parameters.

(2) Horizontal Display:
Configures the Horizontal Display parameters.
         This class of functions configures the triggering of the oscilloscope.

Functions:

(1) General Trigger :
Configures the general trigger parameters.

(2) Edge Trigger:
Configures the edge trigger parameters.

(3) Delay Trigger:
Configures the delay trigger parameters.

(4) Count Trigger:
Configures the count trigger parameters.

(5) Video Trigger:
Configures the video trigger parameters.
        This class of functions configures the display of the oscilloscope.

Functions:

(1) Options :
Configures the optional display parameters.

(2) Waveform:
Configures the waveform display parameters.

(3) Functions:
Configures the functions display parameters.

(4) Measurement:
Configures the measurement display parameters.

(5) Cursors:
Configures the cursors display parameters.

    ;    This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions:

(1) Autoset:
Performs an autoset.

(2) Run/Stop :
Enables or disables the acquisition of input signals.

(3) Hardcopy :
Performs a harcopy.
        This class of functions transfers data to or from the instrument.

Functions:

(1) Read Cursors:
This function reads the cursors positions.

(2) Read Measurements:
This function reads one of the automatic measurement of the oscilloscope.

(3) Waveform:  (Subclass)
This class of functions transfers waveform data to or from the instrument.

(4) Transfer:  (Subclass)
This class of functions transfers files to or from the instrument.
    P    This class of functions transfer waveform data to or from the instrument.

Functions:

(1) Read Channel to Array:
Reads a trace from the instrument and places it in an array.

(2) Read Channel to File:
Reads a trace from the instrument and places it in a file.

(3) Read File to Array:
Reads a file and places it in an array.

(4) Write Array to Memory:
Writes a waveform saved as an array to an instrument display memory.

(5) Write File to Memory:
Writes a waveform saved as a file to an instrument display memory.

(6) Write Array to File:
Writes a waveform saved as an array to a file.
    `    This class of functions transfer files to or from the instrument.

Functions:

(1) Save/Recall Setup to/from File:
Saves a setup to a file or recalls a setup from a file.

(2) File transfer:
Tranfers any file (.trc or .cfg) from any drive (computer or OX2000 memory or OX2000 PC-Card) to any other drive (computer or OX2000 memory or OX2000 PC-Card).        This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(2) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(3) Reset:
This function resets the instrument to its default state.

(4) Self-Test:
This function runs the instrument self test and returns the test code.

(5) Error Query:
This function reads an error code from the instrument error queue.

(6) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(7) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.

(8) Front Panel Lockout:
This function allows the user to lock or unlock the front panel of the instrument. 
        This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Resets the instrument to a known state.

- Serial Parameters are: Speed = 19200, Parity = None, Data = 8 bits, Protocol = RTS/CTS (hard)

- Sends initialization commands to the instrument that set any necessary programmatic variables such as Headers Off, Short Command form, and Data Transfer Binary to the state necessary for the operation of the instrument driver.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "GPIB::1"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
GPIB        GPIB[board]::primary address[::secondary address]
            [::INSTR]
Serial      ASRL<port>::INSTR

The GPIB keyword is used with GPIB instruments.
The ASRL keyword is used with Serial instruments.

The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
board                       0
secondary address           none - 31
port                        1 - 16
        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.    C    This control specifies if the instrument is to be reset to its power-on settings during the initialization procedure.

Valid Range:
VI_OFF (0) - Don't Reset
VI_ON  (1) - Reset Device (Default Value)

Notes:

(1) If you do not want the instrument reset. Set this control to "Don't Reset" while initializing the instrument.    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.

BFFC0011  Instrument returned invalid response to ID Query

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.    Y /         Resource Name                     9 )        ID Query                          !_ ,        Reset Device                      "     }    Instrument Handle                 ##      Status                           O                                             
"GPIB::1"  ! Do Query VI_ON Skip Query VI_OFF  & Reset Device VI_ON Don't Reset VI_OFF    	           	           ZSerial Parameters : 
Speed = 19200
Parity = None
Data = 8 bits
Protocol = RTS/CTS (hard)
   }    This function is an example of this driver's functions use.

The instrument is set to the single shot mode.
User can change the source channel, the timebase, the input voltage range and the input coupling.
A trigger is then sent to the instrument.
The function waits until the acquisition is completed.
Channel is read out from the instrument.
Waveform is interpolated if needed.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Channel) out of range.
BFFC0003  Parameter 3 (Timebase) out of range.
BFFC0004  Parameter 4 (Voltage Range) out of range.
BFFC0005  Parameter 5 (Coupling) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     m    This control selects the source channel.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4     x    This control selects the input coupling of the selected channel.

Valid Values:
0 - AC  (Default Value)
1 - DC
2 - GND        This control selects the main timebase (A) value.

Valid Values: 
0  - 2ns 
1  - 5ns
2  - 10ns  
3  - 20ns 
4  - 50ns
5  - 100ns  
6  - 200ns
7  - 500ns - (Default Value)
8  - 1s  
9  - 2s
10 - 5s
11 - 10s  
12 - 20s 
13 - 50s
14 - 100s  
15 - 200s 
16 - 500s 
17 - 1ms  
18 - 2ms  
19 - 5ms 
20 - 10ms   
21 - 20ms 
22 - 50ms 
23 - 100ms   
24 - 200ms  
25 - 500ms 
26 - 1s  
27 - 2s
28 - 5s
29 - 10s  
30 - 20s
31 - 50s        This control sets vertical sense for the specified channel. 

Valid Values:

0  - 2mV/div 
1  - 5mV/div  
2  - 10mV/div           
3  - 20mV/div           
4  - 50mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div           
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  (Default Value)
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            
16 - 500V/div            
17 - 1kV/div              

Note : This control value must be consistent with the probe value. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER7 (0xBFFC0907)


         This control specifies the name of the array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.     R    This control returns the number of valid points read from the selected channel.
     i    This control returns the time of the first data point in seconds (with respect to the trigger point).

     I    This control returns the incrementing value in seconds for the X axis.
    ,#      Status                            0#         Instrument Handle                 1v ) G       Source                            1 )  P    Coupling                          2k )   P    Time base A                       4# )  P    Voltage Range                     7          Waveform Array                    7          Number of samples                 8 ,        X Start                           8         X Increment                        	                          CH1 1 CH2 2 CH3 3 CH4 4              AC 0 DC 1 GND 2              50 S 31 20 S 30 10 s 29 5 S 28 2 S 27 1 S 26 500 mS 25 200 mS 24 100 mS 23 50 mS 22 20 mS 21 10 mS 20 5 mS 19 2 mS 18 1 mS 17 500 S 16 200 S 15 100 S 14 50 S 13 20 S 12 10 S 11 5 S 10 2 S 9 1 S 8 500 nS 7 200 nS 6 100 nS 5 50 nS 4 20 nS 3 10 nS 2 5 nS 1 2 nS 0               \10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50 mV 4 20 mV 3 10 mV 2 5 mV 1 2 mV 0    	            	            	           	               This function configures the selected input channel of the instrument.

The following settings are available :
- Channel
- State
- Coupling
- Probe
- Channel inversion
- Range
- Offset
- Bandwidth limitation        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Input) out of range.
BFFC0003  Parameter 3 (State) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Probe) out of range.
BFFC0006  Parameter 6 (Polarity) out of range.
BFFC0007  Parameter 7 (Volts/div) out of range.
BFFC0008  Parameter 8 (Offset) out of range.

BFFC0803  Error scanning response.
BFFC0809  Parameter 9 (Bandwidth) out of range.

BFFC0900  Instrument specific error.
BFFC0907  Parameter 7 (Volts/div) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     s    This control selects the channel to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4     y    This control selects the coupling of the specified channel.

Valid Values: 
0 - AC  
1 - DC  (Default Value)
2 - GND  
         This control selects the polarity of the specified channel.

Valid Values: 
VI_ON  (1) - Normal  (Default Value)
VI_OFF (0) - Inverted
     y    This control selects the probe of the specified channel.

Valid Values: 
1 - x 1  (Default Value)
2 - x 10
3 - x 100  
        This control sets vertical sense for the specified channel. 

Valid Values:

0  - 2mV/div 
1  - 5mV/div  
2  - 10mV/div           
3  - 20mV/div           
4  - 50mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div           
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  (Default Value)
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            
16 - 500V/div            
17 - 1kV/div              

Note : This control value must be consistent with the probe value. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER7 (0xBFFC0907)


        This control sets the signal offset of the specified channel. 

Valid Ranges:

vertical sense       offset range
2mV/div              +/- 80mV
5mV/div              +/- 80mV
10mV/div             +/- 400mV
20mV/div             +/- 400mV
50mV/div             +/- 2V
100mV/div            +/- 2V
200mV/div            +/- 2.5V
500mV/div            +/- 12.5V
1V/div               +/- 12.5V
2V/div               +/- 64V
5V/div               +/- 64V
10V/div              +/- 64V
20V/div              +/- 640V
50V/div              +/- 640V
100V/div             +/- 640V
200V/div             +/- 6400V
500V/div             +/- 6400V
1kV/div              +/- 6400V

Default Value: 0.0
         This control selects the state of the specified channel.

Valid Values: 
VI_ON  (1) - 150 MHz  (Default Value)
VI_OFF (0) - 20 MHz
     }    This control selects the state of the specified channel.

Valid Values: 
VI_ON  (1) - On  (Default Value)
VI_OFF (0) - Off
    =#      Status                            Cf#         Instrument Handle                 D ) G       Input                             D )       Coupling                          E )       Polarity                          E )       Probe                             F  d  K    Volt/Div                          I    K    Offset (volts)                    K        Bandwidth                         L> )         State                              	                          CH1 1 CH2 2 CH3 3 CH4 4              AC 0 DC 1 GND 2   Norm VI_ON Inv VI_OFF               x1 0 x10 1 x100 2              1 kV 17 500 V 16 200 V 15 100 V 14 50 V 13 20 V 12 10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50 mV 4 20 mV 3 10 mV 2 5 mV 1 2 mV 0    0.0   150 MHz VI_ON 20 MHz VI_OFF   On VI_ON Off VI_OFF   <    This function configures the horizontal settings of the instrument.

The following settings are available :

- Acquisition size
- Pretrigger 
- Run after delay
- RangeA (the main timebase)
- DelayA (the offset on the main timebase)
- RangeB (the auxiliary timebase)
- DelayB (the offset on the auxiliary timebase)
    P    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Size) out of range.
BFFC0003  Parameter 3 (Pretrig) out of range.
BFFC0004  Parameter 4 (Delay) out of range.
BFFC0005  Parameter 5 (RangeA) out of range.
BFFC0006  Parameter 6 (DelayA) out of range.
BFFC0007  Parameter 7 (RangeB) out of range.
BFFC0008  Parameter 8 (DelayB) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC0907  Parameter 7 (RangeB) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control selects the main timebase (A) value.

Valid Values: 
0  - 2ns 
1  - 5ns
2  - 10ns  
3  - 20ns 
4  - 50ns
5  - 100ns  
6  - 200ns
7  - 500ns - (Default Value)
8  - 1s  
9  - 2s
10 - 5s
11 - 10s  
12 - 20s 
13 - 50s
14 - 100s  
15 - 200s 
16 - 500s 
17 - 1ms  
18 - 2ms  
19 - 5ms 
20 - 10ms   
21 - 20ms 
22 - 50ms 
23 - 100ms   
24 - 200ms  
25 - 500ms 
26 - 1s  
27 - 2s
28 - 5s
29 - 10s  
30 - 20s
31 - 50s     t    This control selects the acquisition size.

Valid Values: 
0 - 1000  (Default Value)
1 - 2000
2 - 5000  
3 - 10000         This control selects the pretrigger position.

Valid Values: 
0  - 0%  
1  - 10%
2  - 20%  
3  - 30% 
4  - 40%
5  - 50% - (Default Value) 
6  - 60% 
7  - 70%
8  - 80%  
9  - 90%
10 - 100%     S    This control selects the Run After Delay value (in seconds).

Default Value: 0.0
     k    This control selects the Offset delay value (in seconds) 
for the main timebase (A).

Default Value: 0.0
        This control selects the auxiliary timebase (B) value.

Valid Values: 
0  - 2ns 
1  - 5ns
2  - 10ns  
3  - 20ns 
4  - 50ns
5  - 100ns  
6  - 200ns
7  - 500ns - (Default Value)
8  - 1s  
9  - 2s
10 - 5s
11 - 10s  
12 - 20s 
13 - 50s
14 - 100s  
15 - 200s 
16 - 500s 
17 - 1ms  
18 - 2ms  
19 - 5ms 
20 - 10ms   
21 - 20ms 
22 - 50ms 
23 - 100ms   
24 - 200ms  
25 - 500ms 
26 - 1s  
27 - 2s
28 - 5s
29 - 10s  
30 - 20s
31 - 50s
32 - 100s
33 - 200s
34 - 500s

Note : This control value must be consistent with the main timebase (A) and the acquisition size values. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER7 (0xBFFC0907)


     q    This control selects the Offset delay value (in seconds) 
for the auxiliary timebase (B).

Default Value: 0.0 
    Q#      Status                            V#         Instrument Handle                 W{ u   P    Range A                           Y3 ) 4       Size                              Y )        Pretrigger                        Zt )       Run after delay (s)               Z u       Delay A (s)                       [B    P    Range B                           ^-        Delay B (s)                      w                                                                                        	                         50 S 31 20 S 30 10 s 29 5 S 28 2 S 27 1 S 26 500 mS 25 200 mS 24 100 mS 23 50 mS 22 20 mS 21 10 mS 20 5 mS 19 2 mS 18 1 mS 17 500 S 16 200 S 15 100 S 14 50 S 13 20 S 12 10 S 11 5 S 10 2 S 9 1 S 8 500 nS 7 200 nS 6 100 nS 5 50 nS 4 20 nS 3 10 nS 2 5 nS 1 2 nS 0              10000 3 5000 2 2000 1 1000 0              N100 % 10 90 % 9 80 % 8 70 % 7 60 % 6 50 % 5 40 % 4 30 % 3 20 % 2 10 % 1 0 % 0    0.0    0.0           #  )500 S 34 200 S 33 100 S 32 50 S 31 20 S 30 10 s 29 5 S 28 2 S 27 1 S 26 500 mS 25 200 mS 24 100 mS 23 50 mS 22 20 mS 21 10 mS 20 5 mS 19 2 mS 18 1 mS 17 500 S 16 200 S 15 100 S 14 50 S 13 20 S 12 10 S 11 5 S 10 2 S 9 1 S 8 500 nS 7 200 nS 6 100 nS 5 50 nS 4 20 nS 3 10 nS 2 5 nS 1 2 nS 0    0.0    Main Time Base (A)    Auxiliary Time Base (B)        This function configures the horizontal display of the instrument.
 
The following settings are available :

- Trace 
- X (for XY mode)
- Y (for XY mode)
- Roll mode
- Cumul mode
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trace) out of range.
BFFC0003  Parameter 3 (X) out of range.
BFFC0004  Parameter 4 (Y) out of range.
BFFC0005  Parameter 5 (Roll) out of range.
BFFC0006  Parameter 6 (Cumul) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     y    This control selects the traces to be displayed.

Valid Values: 
0 - A  (Default Value)
1 - A
2 - A&B  
3 - XY
4 - A&XY     j    This control selects the X input for XY mode.

Valid Values: 
1 - 1  (Default Value)
2 - 2  
3 - 3
4 - 4     j    This control selects the Y input for XY mode.

Valid Values: 
1 - 1  (Default Value)
2 - 2  
3 - 3
4 - 4     a    This control selects the roll mode.

Valid Values: 
0 - Off (Default Value)
1 - On  
2 - Free 
     j    This control selects the cumul mode.

Valid Values: 
VI_OFF (0) - Off (Default Value)
VI_ON  (1) - On  
    d#         Instrument Handle                 e}#      Status                            j? 3 I       Trace                             j 3        X                                 k2 3        Y                                 k 3       Roll                              l
 3       Cumul                                  	                      A 0 B 1 A&B 2 XY 3 A&XY 4               1 1 2 2 3 3 4 4               1 1 2 2 3 3 4 4               Off 0 On 1 Free 2    On VI_ON Off VI_OFF        This function configures the general trigger parameters of the instrument.

The following settings are available :

- Trigger Source 
- Slope
- Coupling
- HF Rejection
- Noise Rejection
- Type
- Level
- Holdoff
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Channel) out of range.
BFFC0003  Parameter 3 (Slope) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (HF Rejection) out of range.
BFFC0006  Parameter 6 (Noise Rejection) out of range.
BFFC0007  Parameter 7 (Type) out of range.
BFFC0008  Parameter 8 (Level) out of range.

BFFC0803  Error scanning response.
BFFC0809  Parameter 9 (Holdoff) out of range.

BFFC0900  Instrument specific error.
BFFC0905  Parameter 5 (HF Rejection) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     z    This control selects the trigger source to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4     |    This control sets the slope of the specified channel.

Valid Values: 
VI_ON  (1) - Up (Default Value)
VI_OFF (0) - Down  
     }    This control selects the coupling mode of the specified channel.

Valid Values: 
0 - AC (Default Value)
1 - DC  
2 - LF Rej        This control sets the HF Rejection of the specified channel.

Valid Values: 
VI_OFF (0) - Off (Default Value)
VI_ON  (1) - On  

Note : This control value must be consistent with the coupling value. HF Rejection can't be set to 'On' with coupling set to 'LF Rejection'. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER5 (0xBFFC0905)


         This control sets the noise rejection of the specified channel.

Valid Values: 
VI_OFF (0) - Off  (Default Value)
VI_ON  (1) - On  
         This control sets level of trigger for the specified channel. 

Valid Range:
0.0 V  to  12 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
     `    This control sets the holdoff value. 

Valid Range:
80.0 ns  to  1.0 s

Default Value: 80.0 ns     u    This control selects the type of trigger.

Valid Values: 
0 - Auto (Default Value)
1 - Triggered  
2 - Peak-to-peak    o~#      Status                            u#         Instrument Handle                 u ) 9       Trigger Source                    v< ) y       Slope                             v )       Coupling                          wE )W       HF Rejection                      y )       Noise Rejection                   y         Level (volts)                     z0 u       Holdoff (seconds)                 z         Type                               	                          CH1 1 CH2 2 CH3 3 CH4 4   Up VI_ON Down VI_OFF               AC 0 DC 1 LF rej 2    On VI_ON Off VI_OFF    On VI_ON Off VI_OFF    0.0    80.0E-9               Auto 0 Trig'd 1 p_p 2        This function configures the edge trigger mode of the instrument.

The following settings are available :

- Trigger source 
- Window
- Main level
- Auxiliary level
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Window) out of range.
BFFC0004  Parameter 4 (Main Level) out of range.
BFFC0005  Parameter 5 (Auxiliary Level) out of range.

BFFC0903  Parameter 3 (Window) is inconsistent.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     v    This control selects the trigger source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4
5 - Line        This control sets the window mode.

Valid Values: 
VI_OFF (0) - Off 
VI_ON  (1) - On  (Default Value)

Note : This control value must be consistent with the source value. Window can't be set to 'On' with trigger source set to 'Line'. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER3 (0xBFFC0903)

         This control sets the auxiliary level of trigger for the trigger source in the window mode. 

Valid Range:
0.0 V  to  12 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
         This control sets the main level of trigger for the trigger source. 

Valid Range:
0.0 V  to  12 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
    ~#         Instrument Handle                 K#      Status                            - 3 L       Trigger Source                     3        Window                            C 3       Auxiliary Level (volts)            3        Main Level (volts)                     	                      CH1 1 CH2 2 CH3 3 CH4 4 Line 5   On VI_ON Off VI_OFF    0.0    0.0    v    This control selects the trigger source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4
5 - Line     x    This control selects the qualifier source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4
5 - Line     d    This control sets the delay value in seconds.

Valid Range:
40 ns  to  16 s

Default Value: 40 ns
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    y    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trigger source) out of range.
BFFC0003  Parameter 3 (Qualifier) out of range.
BFFC0004  Parameter 4 (Delay) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
    H )        Trigger Source                     )       Qualifier                         F          Delay                             #         Instrument Handle                 Q#      Status                                        CH1 1 CH2 2 CH3 3 CH4 4 Line 5               CH1 1 CH2 2 CH3 3 CH4 4 Line 5    40E-9        	           x    This control selects the trigger source.

Valid Values: 
VI_OFF (0) - Qualifier  (Default Value)
VI_ON  (1) - Counter
     z    This control selects the qualifier source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4
5 - Line

     x    This control selects the counter source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4
5 - Line

     d    This control sets the number of events to count.

Valid Range:
1 to 16 777 215 

Default Value: 1
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trigger source) out of range.
BFFC0003  Parameter 3 (Qualifier) out of range.
BFFC0004  Parameter 4 (Counter) out of range.
BFFC0005  Parameter 5 (Events) out of range.

BFFC0905  Parameter 5 (Events) is inconsistent.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
    P ) r       Trigger Source                     )       Qualifier                         R )       Counter                                    Events                            >#         Instrument Handle                 #      Status                             Counter VI_ON Qualifier VI_OFF               CH1 1 CH2 2 CH3 3 CH4 4 Line 5               CH1 1 CH2 2 CH3 3 CH4 4 Line 5    1        	               This function configures the video trigger mode of the instrument.

The following settings are available :

- Trigger source 
- Standard
- Polarity
- Field
- Line
     m    This control selects the trigger source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4        This control selects the number of the line.

Valid Range: 

Sandard      Field      Range
525          even       1 to 262
525          odd        1 to 263
625          even       314 to 625
625          odd        1 to 313

Default Value: 1

Note : This control value must be consistent with the field and standard values. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER6 (0xBFFC0906)

         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trigger Source) out of range.
BFFC0003  Parameter 3 (Standard) out of range.
BFFC0004  Parameter 4 (Polarity) out of range.
BFFC0005  Parameter 5 (Field) out of range.
BFFC0006  Parameter 6 (line) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC0906  Parameter 6 (Line) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     j    This control selects the standard.

Valid Values: 
VI_OFF (0) - 525  
VI_ON  (1) - 625  (Default Value)
     p    This control selects the polarity.

Valid Values: 
VI_OFF (0) - Pos (+)  (Default Value)
VI_ON  (1) - Neg (-)
     f    This control selects the field.

Valid Values: 
VI_OFF (0) - Odd  (Default Value)
VI_ON  (1) - Even
    ; )        Trigger Source                             Line                              #         Instrument Handle                 B#      Status                            I )        Standard                           )I       Polarity                          3 )       Field                                         CH1 1 CH2 2 CH3 3 CH4 4    1        	          625 VI_ON 525 VI_OFF    Neg (-) VI_ON Pos (+) VI_OFF    Even VI_ON Odd VI_OFF        This function configures the display options of the instrument.

The following settings are available :

- Grid 
- Color
- Screen
- Menu
- Language
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Grid) out of range.
BFFC0003  Parameter 3 (Color) out of range.
BFFC0004  Parameter 4 (Screen) out of range.
BFFC0005  Parameter 5 (Menus) out of range.
BFFC0006  Parameter 6 (Language) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     k    This control sets the grid display.

Valid Values: 
VI_OFF (0) - Off  
VI_ON  (1) - On   (Default Value)
     r    This control selects the color of the display.

Valid Values: 
0 - Dark   (Default Value)
1 - Light
2 - White        z    This control selects the number of screens displayed.

Valid Values: 
VI_OFF (0) - 1   (Default Value)
VI_ON  (1) - 4           This control sets the menus to be displayed or not.

Valid Values: 
0  - Off   (Default Value)
1  - Display
2  - Time base
3  - Channel 1
4  - Channel 2
5  - Channel 3
6  - Channel 4
7  - Trigger coupling
8  - Trigger mode/source
9  - Trigger select
10 - Cursors
11 - Time measurement
12 - Voltage measurement
13 - Functions
14 - Utility
15 - Files
16 - Port config
17 - Hardcopy
18 - Calibrate
19 - View setup
20 - Memory

         This control selects the language used on the instrument.

Valid Values: 
0 - French   
1 - English  (Default Value)
2 - German       ?#      Status                            
#         Instrument Handle                  3 %       Grid                               3        Color                              3        Screen                             3       Menu                               3       Language                           	              On VI_ON Off VI_OFF               Dark 0 Light 1 White 2    4 VI_ON 1 VI_OFF              Off 0 Display 1 Time base 2 Channel 1 3 Channel 2 4 Channel 3 5 Channel 4 6 Trigger coupling 7 Trigger mode/soucre 8 Trigger select 9 Cursors 10 Time measurement 11 Voltage measurement 12 Functions 13 Utility 14 Files 15 Port config  16 Hardcopy 17 Calibrate 18 View set-up 19 Memory 20              French 0 English 1 German 2        This function configures the waveform display of the instrument.

The following settings are available :

- Mode 
- Average rate
- Persistence
- Interpolation
         This control selects the display mode.

Valid Values: 
0 - Normal  (Default Value)
1 - Dot join  
2 - Persistence
3 - MinMax  
4 - Envelope     w    This control sets the average rate.

Valid Values: 
0 - 1  (Default Value)
1 - 2  
2 - 4
3 - 8  
4 - 16
5 - 32
6 - 64         This control sets the persistence.

Valid Values: 
0 - 200 ms  (Default Value)
1 - 500 ms  
2 - 1 s
3 - 2 s  
4 - 5 s
5 - 10 s
6 - inf     k    This control selects the interpolation.

Valid Values: 
0 - None  (Default Value)
1 - Linear  
2 - Smooth         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Average rate) out of range.
BFFC0004  Parameter 4 (Persistence) out of range.
BFFC0005  Parameter 5 (Interpolation) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
    / 3 U       Mode                               3   F    Average rate                      C 3/  P    Persistence                        3       Interpolation                     F#         Instrument Handle                 #      Status                                        6Normal 0 Dot join 1 Persistence 2 MinMax 3 Envelope 4              64 6 32 5 16 4 8 3 4 2 2 1 1 0              1inf 6 10 S 5 5 S 4 2 S 3 1 S 2 500 mS 1 200 mS 0               None 0 Linear 1 Smooth 2        	               This function configures the mathematical facility of the instrument for waveform operations.

The following settings are available :

- Select 
- Function
- Source1
- Source2         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Select) out of range.
BFFC0003  Parameter 3 (Function) out of range.
BFFC0004  Parameter 4 (Source1) out of range.
BFFC0005  Parameter 5 (Source2) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     q    This control selects the operation to perform.

Valid Values: 
0 - Off  (Default Value)
1 - Add
2 - Sub
3 - Mul     k    This control selects the first source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4     l    This control selects the second source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4     s    This control selects the function to configure.

Valid Values: 
VI_OFF (0) - F1  (Default Value)
VI_ON  (1) - F2
    z#         Instrument Handle                 #      Status                             3        Function                          9 3O       Source 1                          Ĭ 3       Source 2                            3 @       Select                                 	                      Off 0 Add 1 Sub 2 Mul 3               CH1 1 CH2 2 CH3 3 CH4 4               CH1 1 CH2 2 CH3 3 CH4 4    F2 VI_ON F1 VI_OFF        This function selects an automatical measurement from the instrument and displays it.

The following settings are available :

- Edit 
- Measurement
- Reference
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    t    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Edit) out of range.
BFFC0003  Parameter 3 (Measurement) out of range.
BFFC0004  Parameter 4 (Reference) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     j    This control selects the edit mode.

Valid Values: 
0 - Insert  (Default Value)
1 - Delete
2 - Clear all         This control selects the reference channel for the measurement.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4        This control selects the measurement to display.

Valid Values: 
0  - RMS Voltage     [V]  (Default Value)
1  - Amplitude       [V]
2  - Peak to Peak    [V]
3  - Average Voltage [V]
4  - High Voltage    [V]
5  - Low Voltage     [V]
6  - Maximum Voltage [V]
7  - Minimum Voltage [V]
8  - Overshoot       [%]
9  - Frequency       [Hz]
10 - Period          [s]
11 - Fall Time       [s]
12 - Rise Time       [s]
13 - Pos Pulse Width [s]
14 - Neg Pulse Width [s]
15 - Dutycycle       [%]    #         Instrument Handle                 Ⱦ#      Status                            : 3 f       Edit                              ͬ 3       Reference                         8 3   x    Measurement                            	                      Insert 0 Delete 1 Clear all 2               CH1 1 CH2 2 CH3 3 CH4 4               RMS Voltage 0 Amplitude 1 Peak to Peak 2 Average Voltage 3 High Voltage 4 Low Voltage 5 Maximum Voltage 6 Minimum Voltage 7 Overshoot 8 Frequency 9 Period 10 Fall Time 11 Rise Time 12 Pos Pulse Width 13 Neg Pulse Width 14 Dutycycle 15        This function sets vertical and horizontal cursors.

The following settings are available :

- Clear Cursors 
- Reference
- T1 
- T2
- V1
- V2
     }    This control allows you to clear or display the cursors.

Valid Values:
VI_OFF (0) - Off 
VI_ON  (1) - On  (Default Value)
     h    This control selects the reference.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Clear Cursors) out of range.
BFFC0003  Parameter 3 (Reference) out of range.
BFFC0004  Parameter 4 (T1) out of range.
BFFC0005  Parameter 5 (T2) out of range.
BFFC0006  Parameter 6 (V1) out of range.
BFFC0007  Parameter 7 (V2) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control sets the position of the vertical cursor #1.

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

Default Value:
-2.5E-6 s         This control sets the position of the vertical cursor #2.

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

Default Value:
-2.5E-6 s         This control sets the position of the horizontal cursor #1.

Valid Range:
+/- 80 * vertSense (vertSense in V/div)

Default Value:
40.0 V         This control sets the position of the horizontal cursor #2.

Valid Range:
+/- 80 * vertSense (vertSense in V/div)

Default Value:
40.0 V    $ ) K       Cursors                           ө )        Reference                         #         Instrument Handle                 Ը#      Status                            ٮ )       T1 (s)                            D a        T2 (s)                                    V1 (V)                            l        V2 (V)                            On VI_ON Off VI_OFF               CH1 1 CH2 2 CH3 3 CH4 4        	           -2.5E-6    2.5E-6    -2    2       This function sets hardcopy parameters.

The following settings are available :

- Device 
- Port
- Filename 
- # of Pages
- Page Number
- # of Pens

Note :
 
The '# of Pages' and 'Page Number' controls are only effective after running a hardcopy with the 'runHardcopy' function.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    `    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Device) out of range.
BFFC0003  Parameter 3 (Port) out of range.
BFFC0004  Parameter 4 (Filename) out of range.
BFFC0005  Parameter 5 (Type) out of range.
BFFC0006  Parameter 6 (# of pages) out of range.
BFFC0007  Parameter 7 (Page Number) out of range.
BFFC0008  Parameter 8 (# of pens) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC0906  Parameter 6 (# of pages) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the device language.

Valid Values: 
0  - IBM Proprinter (Default Value)
1  - EPSON ESC/P2
2  - HP-PCL
3  - HPGL
4  - Seiko I          This control selects the measurement to display.

Valid Values: 
0  - File on CARD
1  - RS232 (Default Value)
2  - Centronics
3  - GPIB        This control sets the filename where to store the hardcopy.

Default Value: ""

Note : It must be an 8-character name with no extension. Extension is automatically added according to the device language. See the Digiscope 2000 Operating Instructions manual for more details.         This control sets the number of pens used.

Valid Values:
VI_OFF (0) - 2  
VI_ON  (1) - 7 (Default Value)

Note : This parameter is only taken into account for an HPGL device.
         This control selects on which page to print the hardcopy.

Valid Values:
1 - 1  (Default Value)
2 - 2
3 - 3
4 - 4

Note : This parameter is only taken into account if 4-page printing mode is active for an HPGL device.        This control sets the number of pages.

Valid Values:
VI_OFF (0) - 1  (Default Value)
VI_ON  (1) - 4

Note : This control value must be consistent with the device value. 4-page printing mode is only valid with HPGL devices.
See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER6 (0xBFFC0906)
     w    This control sets the number of pages.

Valid Values:
VI_OFF (0) - Black & White  (Default Value)
VI_ON  (1) - Color
    5#         Instrument Handle                 #      Status                            < )        Device                             )        Port                              j )        Filename                                  # of pens                         @ p       Page number                       #         # of pages                                 Type                                   	                      RIBM Proprinter 0 Epson ESC/P2 1 HP PCL 2 HPGL 3 Seiko I 4 EPS Image 5 BMP Image 6               +RS232 1 Centronics 2 GPIB 3 File on CARD 0    ""   7 VI_ON 2 VI_OFF               1 1 2 2 3 3 4 4    4 VI_ON 1 VI_OFF  !  Color VI_ON Black & White VI_OFF    6    This function performs an autoset of the instrument.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090F  No channel is enabled.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    f#      Status                            v#         Instrument Handle                  	               D    This function controls the acquisition system of the instrument. 
    >    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Wait?) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control sets the acquisition system of the instrument.

Valid Values:
0 - Continuous  (Default Value)
1 - Single Shot
2 - Abort
         This control selects whether to wait until a single shot operation is completed.

Valid Values:
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes

Note:

This control is valid only if the single shot trigger mode is selected.    #      Status                            !#         Instrument Handle                  3        Mode                              O 3X        Wait?                              	                          #Continuous 0 Single Shot 1 Abort 2    Yes VI_ON No VI_OFF    ?    This function controls the hardcopy system of the instrument.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Action) out of range.

BFFC0803  Error scanning response

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control selects whether to run the hardcopy or to abort it. 

Valid Values:
VI_OFF (0) - Abort  
VI_ON  (1) - Run     (Default Value)
    #      Status                            #         Instrument Handle                 C 3       Action                             	              Run VI_ON Abort VI_OFF    Z    This function reads cursors positions.
All measured quantities are in their basic units.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Reference) out of range.
BFFC0003  Parameter 3 (T1) out of range.
BFFC0004  Parameter 4 (T2) out of range.
BFFC0005  Parameter 5 (dT) out of range.
BFFC0006  Parameter 6 (V1) out of range.
BFFC0007  Parameter 7 (V2) out of range.
BFFC0008  Parameter 8 (dV) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the reference channel for the cursors positions.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4     ?    This control outputs the position of the vertical cursor #1.
     ?    This control outputs the position of the vertical cursor #2.
     ?    This control outpus the difference between vertical cursors.
     @    This control outpus the position of the horizontal cursor #1.
     ?    This control outpus the position of the horizontal cursor #2.     A    This control outpus the difference between horizontal cursors.
   #         Instrument Handle                #      Status                            ) N       Reference                        I )         T1 (s)                            l         T2 (s)                                     dT (s)                           	 )f        V1 (v)                           	f lf        V2 (v)                           	 f        dV (v)                                 	                      CH1 1 CH2 2 CH3 3 CH4 4    	           	           	           	           	           	               This function forces the instrument to perform selected measurement and returns the result.
All measured quantities are in their basic units.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    w    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Measurement) out of range.
BFFC0003  Parameter 3 (Reference) out of range.
BFFC0004  Parameter 4 (Reading) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the reference channel for the specified measurement.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4     n    This control outputs the result of the measurement.
All measured quantities are output in their basic units.        This control specifies the measurement function.

Valid Values: 
0  - RMS Voltage     [V]  (Default Value)
1  - Amplitude       [V]
2  - Peak to Peak    [V]
3  - Average Voltage [V]
4  - High Voltage    [V]
5  - Low Voltage     [V]
6  - Maximum Voltage [V]
7  - Minimum Voltage [V]
8  - Overshoot       [%]
9  - Frequency       [Hz]
10 - Period          [s]
11 - Fall Time       [s]
12 - Rise Time       [s]
13 - Pos Pulse Width [s]
14 - Neg Pulse Width [s]
15 - Dutycycle       [%]
   #         Instrument Handle                
#      Status                            3       Reference                         3z        Reading                           3 6  x    Measurement                            	                      CH1 1 CH2 2 CH3 3 CH4 4    	                      RMS Voltage 0 Amplitude 1 Peak to Peak 2 Average Voltage 3 High Voltage 4 Low Voltage 5 Maximum Voltage 6 Minimum Voltage 7 Overshoot 8 Frequency 9 Period 10 Fall Time 11 Rise Time 12 Pos Pulse Width 13 Neg Pulse Width 14 Dutycycle 15    [    This function reads the specified channel from the instrument and places it in an array.
     m    This control selects the source channel.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4         This function specifies the name of array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.     S    This function returns the number of valid points read from the selected channel.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Interpolation) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     j    This function returns the time of the first data point in seconds (with respect to the trigger point).

     J    This function returns the incrementing value in seconds for the X axis.
    8    This control selects whether to interpolate or not the samples when in ETS acquisition (see OX2000 operating instructions manual for more details).

Valid Values:
VI_OFF (0) - Off (Default Value)
VI_ON  (1) - Linear

Note 

(1) If interpolation is not selected, invalid points take the following value : 1E+100    3        Source                                     Waveform Array                             Number of samples                 #         Instrument Handle                #      Status                           Q +        X Start                                   X Increment                       3X       Interpolation                                 CH1 1 CH2 2 CH3 3 CH4 4    	            	                	           	           	           Linear VI_ON Off VI_OFF    M    This function reads a channel from the instrument and stores it as a file.
     m    This control selects the source channel.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Drive) out of range.
BFFC0004  Parameter 4 (Filename) out of specifications.
BFFC0005  Parameter 5 (Overwrite File?) out of range.

BFFC0801  Error writing to file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.
BFFC090E  File already exists.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
        This function specifies the name of the wave data file.

Default Value: ""

Notes:

(1) When storing a file to Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 8-character long plus ".TRC" extension.
If not, an error is generated :0xBFFC0004 

(3) If the target file already exists and overwrite is not selected, an error is generated : 0xBFFC090E

     n    This control selects the destination drive.

Valid Values:
0 - Computer
1 - OX2000 Memory
2 - OX2000 PC-CARD         This function specifies whether or not to write over the specified file if it already exists.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
   " )        Source                           #I#         Instrument Handle                ##      Status                           (         File Name                        *         Drives                           +b         Overwrite File?                               CH1 1 CH2 2 CH3 3 CH4 4        	           ""               ,Computer 0 OX2000 Memory 1 OX2000 PC Card 2    Yes VI_ON No VI_OFF    N    This function reads a stored waveform file and places the data in an array.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Drive) out of range.
BFFC0003  Parameter 3 (Filename) out of specifications.
BFFC0004  Parameter 4 (Interpolation) out of range.

BFFC0800  Error opening file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     i    This control selects the source drive.

Valid Values:
0 - Computer
1 - OX2000 Memory
2 - OX2000 PC-CARD        This function specifies the name of the wave data file.

Default Value: ""

Notes:

(1) When reading a file from Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 8-character long + ".TRC" extension.
If not an error is generated :0xBFFC0003  

(3) If file does not exist an error is generated : 0xBFFC090D



         This function specifies the name of array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.     P    This function returns the number of valid points read from the selected file.
     j    This function returns the time of the first data point in seconds (with respect to the trigger point).

     J    This function returns the incrementing value in seconds for the X axis.
    8    This control selects whether to interpolate or not the samples when in ETS acquisition (see OX2000 operating instructions manual for more details).

Valid Values:
VI_OFF (0) - Off (Default Value)
VI_ON  (1) - Linear

Note 

(1) If interpolation is not selected, invalid points take the following value : 1E+100   ./#         Instrument Handle                .#      Status                           3 )        Drives                           4 )        File Name                        5          Waveform Array                   6          Number of samples                6 .        X Start                          7R         X Increment                      7 )       Interpolation                          	                      ,Computer 0 OX2000 Memory 1 OX2000 PC Card 2    ""    	            	            	           	           Linear VI_ON Off VI_OFF    B    This function writes an array to the instrument display memory.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0003  Parameter 3 (Size Of Array) out of range.
BFFC0004  Parameter 4 (Volt/Div) out of range.
BFFC0005  Parameter 5 (Offset) out of range.
BFFC0006  Parameter 6 (Target) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     h    This control selects the target memory.

Valid Values: 
1 - M1  (Default Value)
2 - M2
3 - M3  
4 - M4     J    This control specifies the waveform array to display.
Data are in volts.        This control sets the vertical sense for the data to be displayed. 

Valid Values:

0  - 2mV/div 
1  - 5mV/div  
2  - 10mV/div           
3  - 20mV/div           
4  - 50mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div           
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  (Default Value)
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            
16 - 500V/div            
17 - 1kV/div                      This control sets the offset in volts for the data to be displayed.

Valid Ranges:

vertical sense       offset range
2mV/div              +/- 80mV
5mV/div              +/- 80mV
10mV/div             +/- 400mV
20mV/div             +/- 400mV
50mV/div             +/- 2V
100mV/div            +/- 2V
200mV/div            +/- 2.5V
500mV/div            +/- 12.5V
1V/div               +/- 12.5V
2V/div               +/- 64V
5V/div               +/- 64V
10V/div              +/- 64V
20V/div              +/- 640V
50V/div              +/- 640V
100V/div             +/- 640V
200V/div             +/- 6400V
500V/div             +/- 6400V
1kV/div              +/- 6400V

Default Value: 0.0
     9    This control specifies the number of points to display.        This control sets the vertical sense for the data to be displayed. 

Valid Values: 
0  - 2ns 
1  - 5ns
2  - 10ns  
3  - 20ns 
4  - 50ns
5  - 100ns  
6  - 200ns
7  - 500ns - (Default Value)
8  - 1s  
9  - 2s
10 - 5s
11 - 10s  
12 - 20s 
13 - 50s
14 - 100s  
15 - 200s 
16 - 500s 
17 - 1ms  
18 - 2ms  
19 - 5ms 
20 - 10ms   
21 - 20ms 
22 - 50ms 
23 - 100ms   
24 - 200ms  
25 - 500ms 
26 - 1s  
27 - 2s
28 - 5s
29 - 10s  
30 - 20s
31 - 50s   ;#         Instrument Handle                <F#      Status                           @        Target                           Ab )         Waveform Array                   A u s  K    Volt/Div                         C u   K    Offset (volts)                   Ft )>       Number of points                 F ug  P    Sec/Div                                	                      M1 1 M2 2 M3 3 M4 4                  1 kV 17 500 V 16 200 V 15 100 V 14 50 V 13 20 V 12 10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50 mV 4 20 mV 3 10 mV 2 5 mV 1 2 mV 0    0.0    1000              50 S 31 20 S 30 10 s 29 5 S 28 2 S 27 1 S 26 500 mS 25 200 mS 24 100 mS 23 50 mS 22 20 mS 21 10 mS 20 5 mS 19 2 mS 18 1 mS 17 500 S 16 200 S 15 100 S 14 50 S 13 20 S 12 10 S 11 5 S 10 2 S 9 1 S 8 500 nS 7 200 nS 6 100 nS 5 50 nS 4 20 nS 3 10 nS 2 5 nS 1 2 nS 0    J    This function writes a wave data file to the instrument display memory.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Drive) out of range.
BFFC0003  Parameter 3 (Filename) out of specifications.
BFFC0004  Parameter 4 (Overwrite File?) out of range.

BFFC0800  Error opening file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     h    This control selects the target memory.

Valid Values: 
1 - M1  (Default Value)
2 - M2
3 - M3  
4 - M4     z    This control selects the source drive.

Valid Values:
0 - Computer  (Default value)
1 - OX2000 Memory
2 - OX2000 PC-CARD        This control selects the target memory.

Default Value: ""

Notes:

(1) When reading a file from Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 8-character long + ".TRC" extension.
If not an error is generated :0xBFFC0003  

(3) If file does not exist an error is generated : 0xBFFC090D

   Lz#         Instrument Handle                M#      Status                           Q        Target                           Rj )        Drives                           R )'       File Name                              	                      M1 1 M2 2 M3 3 M4 4               ,Computer 0 OX2000 Memory 1 OX2000 PC Card 2    ""    5    This function writes an array to a wave data file.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0003  Parameter 3 (Size Of Array) out of range.
BFFC0004  Parameter 4 (Volt/Div) out of range.
BFFC0005  Parameter 5 (Offset) out of range.
BFFC0006  Parameter 6 (timeBase) out of range.
BFFC0007  Parameter 7 (Drive) out of range.
BFFC0008  Parameter 8 (Filename) out of specifications.

BFFC0801  Error writing to file.
BFFC0803  Error scanning response.
BFFC0809  Parameter 9 (Overwrite File?) out of range.

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.
BFFC090E  File already exists.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     z    This control selects the target drive.

Valid Values:
0 - Computer  (Default Value)
1 - OX2000 Memory
2 - OX2000 PC-CARD        This function specifies the name of the wave data file.

Default Value: ""

Notes:

(1) When reading a file from Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 8-character long + ".TRC" extension.
If not an error is generated :0xBFFC0007  

(3) If the target file already exists and overwrite is not selected an error is generated : 0xBFFC090E
         This function specifies whether or not to write over the specified file if it already exists on disk.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
     J    This control specifies the waveform array to display.
Data are in volts.        This control sets the vertical sense for the data to be displayed. 

Valid Values:

0  - 2mV/div 
1  - 5mV/div  
2  - 10mV/div           
3  - 20mV/div           
4  - 50mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div           
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  (Default Value)
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            
16 - 500V/div            
17 - 1kV/div                   9    This control specifies the number of points to display.        This control sets the offset in volts for the data to be displayed.

Valid Ranges:

vertical sense       offset range
2mV/div              +/- 80mV
5mV/div              +/- 80mV
10mV/div             +/- 400mV
20mV/div             +/- 400mV
50mV/div             +/- 2V
100mV/div            +/- 2V
200mV/div            +/- 2.5V
500mV/div            +/- 12.5V
1V/div               +/- 12.5V
2V/div               +/- 64V
5V/div               +/- 64V
10V/div              +/- 64V
20V/div              +/- 640V
50V/div              +/- 640V
100V/div             +/- 640V
200V/div             +/- 6400V
500V/div             +/- 6400V
1kV/div              +/- 6400V

Default Value: 0.0        This control sets the horizontal sense for the data to be displayed. 

Valid Values: 
0  - 2ns 
1  - 5ns
2  - 10ns  
3  - 20ns 
4  - 50ns
5  - 100ns  
6  - 200ns
7  - 500ns - (Default Value)
8  - 1s  
9  - 2s
10 - 5s
11 - 10s  
12 - 20s 
13 - 50s
14 - 100s  
15 - 200s 
16 - 500s 
17 - 1ms  
18 - 2ms  
19 - 5ms 
20 - 10ms   
21 - 20ms 
22 - 50ms 
23 - 100ms   
24 - 200ms  
25 - 500ms 
26 - 1s  
27 - 2s
28 - 5s
29 - 10s  
30 - 20s
31 - 50s   VX#         Instrument Handle                V#      Status                           \         Drives                           ]#         File Name                        _
         Overwrite File?                  _ )         Waveform Array                   ` m y  K    Volt/Div                         b! )]       Number of points                 bb m   K    Offset (volts)                   e m  P    Sec/Div                                	                      ,Computer 0 OX2000 Memory 1 OX2000 PC Card 2    ""    Yes VI_ON No VI_OFF                  1 kV 17 500 V 16 200 V 15 100 V 14 50 V 13 20 V 12 10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50 mV 4 20 mV 3 10 mV 2 5 mV 1 2 mV 0    1000    0.0              50 S 31 20 S 30 10 s 29 5 S 28 2 S 27 1 S 26 500 mS 25 200 mS 24 100 mS 23 50 mS 22 20 mS 21 10 mS 20 5 mS 19 2 mS 18 1 mS 17 500 S 16 200 S 15 100 S 14 50 S 13 20 S 12 10 S 11 5 S 10 2 S 9 1 S 8 500 nS 7 200 nS 6 100 nS 5 50 nS 4 20 nS 3 10 nS 2 5 nS 1 2 nS 0    7    This function save or recall set-up to or from file.
    D    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Drive) out of range.
BFFC0004  Parameter 4 (Filename) out of specifications.
BFFC0005  Parameter 5 (Overwrite File?) out of range.

BFFC0800  Error opening file.
BFFC0801  Error writing to file.
BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC090E  File already exists.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control selects the target/source drive.

Valid Values:
0 - Computer  (Default Value)
1 - OX2000 Memory
2 - OX2000 PC-CARD    ]    This function specifies the name of the setup data file.

Default Value: ""

Notes:

(1) When reading/writing a file from/to Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 8-character long + ".CFG" extension.
If not an error is generated :0xBFFC0004  

(3) When saving a setup : if the target file already exists and overwrite is not selected an error is generated : 0xBFFC090E

(4) When recalling a setup : if file does not exist an error is generated : 0xBFFC090D

         This function specifies whether or not to write over the specified file if it already exists on disk.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
     |    This control selects between Save and Recall mode.

Valid Range:  
VI_OFF (0) - Recall
VI_ON  (1) - Save  (Default Value)
   kd#      Status                           p#         Instrument Handle                qO         Drives                           q         File Name                        t=         Overwrite File?                  t )        Mode                               	                          ,Computer 0 OX2000 Memory 1 OX2000 PC Card 2    ""    Yes VI_ON No VI_OFF   Save VI_ON Recall VI_OFF        This function performs a file transfer.

Note :

Size of files to be transfered from Computer to OX2000 must be less than 65498 bytes.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    S    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Filename) out of specifications.
BFFC0003  Parameter 3 (Source Drive) out of range.
BFFC0004  Parameter 4 (Overwrite File?) out of range.
BFFC0005  Parameter 5 (Target Drive) out of range.

BFFC0800  Error opening file.
BFFC0801  Error writing to file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC090E  File already exists.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     z    This control selects the target drive.

Valid Values:
0 - Computer
1 - OX2000 Memory  (Default value)
2 - OX2000 PC-CARD     z    This control selects the source drive.

Valid Values:
0 - Computer  (Default Value)
1 - OX2000 Memory
2 - OX2000 PC-CARD    <    This function specifies the name of the data file.

Default Value: ""

Notes:

(1) When reading a file from Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 8-character long + ".???" extension.
If not an error is generated :0xBFFC0002  

(3) If the file already exists on the target drive and overwrite is not selected an error is generated : 0xBFFC090E

(4) If file does not exist on the source drive an error is generated : 0xBFFC090D         This function specifies whether or not to write over the specified file if it already exists on disk.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
   w#         Instrument Handle                xd#      Status                           }        Target Drive                     ~A         Source Drive                     ~ +        File Name                                 Overwrite File?                        	                     ,Computer 0 OX2000 Memory 1 OX2000 PC Card 2               ,Computer 0 OX2000 Memory 1 OX2000 PC Card 2    ""    Yes VI_ON No VI_OFF    m    This function writes commands and queries to the instrument to modify parameters and query device settings.    z    The user can use this control to send common commands and queries to the instrument. This control can also be used to write any valid command to the instrument.

Default Value:  "*RST\n"

Notes:

(1) The command or query to be sent to the instrument may be a literal enclosed in double quotes terminated by '\n' i.e. "*RST\n" or may be contained in a variable of type string.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    M E      Write Buffer                     #      Status                           6#         Instrument Handle                  	"*RST\n"    	              7    This function reads data from the instrument's output buffer and returns it to the specified variable in memory.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) If valid data is not available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled this function will hang indefinitely and it may be necessary to reboot the computer to break out.        The number of bytes specified by this control should be greater than or equal to the number of bytes which are to be read from the instrument. If the actual number of bytes to be read is greater than the number this control specifies then multiple reads will be required to empty the instrument's output buffer.

If the instrument's output buffer is not emptied the instrument may return invalid data when future reads are performed.

Default Value:  50 (See NOTE 2)

Notes:

(1) If NO DATA is available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled, this function will hang indefinitely and it may be necessary to reboot the computer.

(2) If the number of bytes expected is greater than 50 the value of this control may be increased. If the actual number of bytes read is larger than the declared size of the read buffer a run-time error will be generated.
        The incoming data from the instrument is placed into this variable.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) This function does not overwrite any old data left in the string variable from the last time the function was called. String data in LabWindows/CVI is terminated with an ASCII null(0x0) and string manipulation functions will only recognize data before the ASCII null.

(3) The declared size of the string variable must be greater than the actual number of bytes read from the instrument if it is not a run-time error will be generated.
        This variable contains the actual number of bytes read from the instrument. This is the value which is returned by the read function.

Notes:

(1) If the actual number of bytes read is less than the number of bytes specified in the Number Bytes To Read control then the output buffer has probably been emptied. If the read function fails and the number of bytes read is 0, the most probable cause for the failure is there was no data available at the instrument's output buffer.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    M K        Number Bytes To Read               H      Read Buffer                      L Mx        NumBytes Read                    4#      Status                           #         Instrument Handle                  50    	            	            	               ~    This function resets the instrument to a known state.
See the Digiscope 2000 Operating Instructions manual for more details.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   5#      Status                           #         Instrument Handle                  	               W    This function runs the instrument's self test routine and returns the test result(s).         This control contains the value returned from the instrument self test.  Zero means success.  For any other code, see the device's operator's manual.
         This control contains the string returned from the self test. See the device's operation manual for an explanation of the string's contents.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0803  Error scanning response.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   R = 2        Self Test Result                  =   ,    Self-Test Message                #      Status                           #         Instrument Handle                  	           	            	               H    This function reads an error code from the instrument's error queue.

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    = 2        Error Code                        =   ,    Error Message                    #      Status                           ,#         Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.
3FFF0085  Unknown status.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL   Z =         Error Code                        =       Error Message                    z#      Status                           9#         Instrument Handle                  0    	            	           VI_NULL   0    This function returns the revision numbers of the instrument driver and instrument firmware, and tells the user what firmware the driver is compatible with, for example:

This instrument driver's Revision Number is "Rev 1.1, 04/98, CVI 4.0.1" and is compatible with Instrument Firmware Revision "1.6".
         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    = 2       Instrument Driver Revision        =,       Firmware Revision                $#      Status                           #         Instrument Handle                  	            	            	               F    This function controls the instrument's front panel lockout state.

        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     k    Controls the front panel lockout.

Valid Range:  
VI_OFF (0) - Unlock  (Default Value)
VI_ON  (1) - Lock
   #      Status                           #         Instrument Handle                ! N        Mode                               	               Lock VI_ON Unlock VI_OFF        This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   #      Status                           Ʊ#         Instrument Handle                  	                       (u     K.    init                                     *  8 
    K.    example                                  <  L 
    K.    verticalSetup                            P@  ^     K.    horizontalSetup                          d!  l     K.    horizontalDisplay                        n  { 
    K.    setGeneralTrigger                        }       K.    setEdgeTrigger                                K.    setDelayedTrigger                             K.    setCountTrigger                                 K.    setVideoTrigger                            Y     K.    setOptionDisplay                                K.    setWaveformDisplay                         ś     K.    setFunction                              t  $     K.    setMeasurement                           ҋ       K.    setCursors                                 / 	    K.    setHardcopy                              (       K.    runAutoset                                 :     K.    runAcquisition                           g       K.    runHardcopy                              	 	    K.    readCursors                             R       K.    readMeasurement                         F  U     K.    readChToArr                             " ,     K.    readChToFile                            - 8 	    K.    readFileToArr                           ;] H     K.    writeArrToMem                           L( T     K.    writeFileToMem                          V f 
    K.    writeArrToFile                          k% us     K.    saveSetup                               w5      K.    fileTransfer                                  K.    writeInstrData                           x     K.    readInstrData                            y     K.    reset                                    7     K.    selfTest                                3      K.    errorQuery                                    K.    errorMessage                             h     K.    revisionQuery                           d      K.    frontPanLock                            _ P     K.    close                                                                      DInitialize                          1Application Functions                DExample                             \Configure Functions                  DVertical Setup                      	:Horizontal                           DHorizontal Setup                     DHorizontal Display                  
Trigger                              DGeneral Trigger                      DEdge Trigger                         DDelayed Trigger                      DCount Trigger                        DVideo Trigger                       Display                              DOptions                              DWaveform                             DFunctions                            DMeasurements                         DCursors                              DHardcopy Setup                      
2Action/Status Functions              DAutoset                              DRun/Stop                             DHardcopy                            uData                                 DRead Cursors                         DRead Measurements                   1Waveform                             DRead Channel To Array                DRead Channel To File                 DRead File To Array                   DWrite Array To Memory                DWrite File To Memory                 DWrite Array To File                 Transfer                             DSave/Recall Setup To/From File       DFile Transfer                       Utility Functions                    DWrite To Instrument                  DRead Instrument Data                 DReset                                DSelf-Test                            DError-Query                          DError Message                        DRevision Query                       DFront Panel Lockout                  DClose                           