#include <cvidef.h>

/*= <MTX3354> Include File ===================================================*/
 
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/
     
#ifndef __mtx3354_HEADER
#define __mtx3354_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)
#define VI_ERROR_INSTR_PARAMETER9               (_VI_ERROR+0x3FFC0809L)
#define VI_ERROR_INSTR_PARAMETER10              (_VI_ERROR+0x3FFC080AL)
#define VI_ERROR_INSTR_PARAMETER11              (_VI_ERROR+0x3FFC080BL)
#define VI_ERROR_INSTR_PARAMETER12              (_VI_ERROR+0x3FFC080CL)
#define VI_ERROR_INSTR_PARAMETER13              (_VI_ERROR+0x3FFC080DL)
#define VI_ERROR_INSTR_PARAMETER14              (_VI_ERROR+0x3FFC080EL)
#define VI_ERROR_INSTR_PARAMETER15              (_VI_ERROR+0x3FFC080FL)

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_WARNING_INSTR_OFFSET                           (0x3FFC0900L)
#define VI_ERROR_INSTR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define PREFIX_ERROR_INVALID_CONFIGURATION      (VI_ERROR_INSTR_OFFSET + 0xF0L)


/*****************************************************************************/
/*= Define Instrument Specific Error Codes Here =============================*/
/*****************************************************************************/
#define VI_ERROR_PARAMETER9             (_VI_ERROR+0x3FFC0009L)


#define VI_ERROR_MTX3354_ERROR                   (_VI_ERROR+0x3FFC0900L)
#define VI_ERROR_MTX3354_INCONSISTENT_PARAMETER3 (_VI_ERROR+0x3FFC0903L)
#define VI_ERROR_MTX3354_INCONSISTENT_PARAMETER5 (_VI_ERROR+0x3FFC0905L)
#define VI_ERROR_MTX3354_INCONSISTENT_PARAMETER6 (_VI_ERROR+0x3FFC0906L)
#define VI_ERROR_MTX3354_INCONSISTENT_PARAMETER7 (_VI_ERROR+0x3FFC0907L)
#define VI_ERROR_MTX3354_AUTOTEST_PROBLEM        (_VI_ERROR+0x3FFC090BL)
#define VI_ERROR_MTX3354_CHAN_NOT_ACTIVE         (_VI_ERROR+0x3FFC090CL)
#define VI_ERROR_MTX3354_FILE_NOT_FOUND          (_VI_ERROR+0x3FFC090DL)
#define VI_ERROR_MTX3354_EXISTING_FILE           (_VI_ERROR+0x3FFC090EL)
#define VI_ERROR_MTX3354_NO_CHAN_ENABLED         (_VI_ERROR+0x3FFC090FL)
#define VI_ERROR_MTX3354_INVALID_FILE_CONTENT    (_VI_ERROR+0x3FFC0910L)
/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus _VI_FUNC mtx3354_init (ViRsrc resourceName, ViBoolean IDQuery,
                    ViPSession instrumentHandle);
ViStatus _VI_FUNC mtx3354_example (ViSession instrumentHandle, ViInt16 source,
                    ViInt16 timebaseA, ViInt16 voltageRange, ViInt16 coupling,
                    ViReal64 _VI_FAR waveformArray[], ViPInt32 numberofsamples, 
                    ViPReal64 XStart, ViPReal64 XIncrement);
ViStatus _VI_FUNC mtx3354_verticalSetup (ViSession instrumentHandle, ViInt16 input,
                    ViBoolean state, ViInt16 coupling, ViInt16 probe,
                    ViInt16 voltDiv, ViReal64 offsetvolts, ViReal64 bandwidth);
ViStatus _VI_FUNC mtx3354_horizontalSetup (ViSession instrumentHandle,
                    ViInt16 range, ViReal64 runafterdelays);
ViStatus _VI_FUNC mtx3354_horizontalDisplay (ViSession instrumentHandle,
                    ViInt16 trace, ViInt16 x, ViInt16 y);
ViStatus _VI_FUNC mtx3354_FFT (ViSession instrumentHandle, ViBoolean ffton_off, ViInt16 calculate, 
								ViBoolean scalelog_linear);
ViStatus _VI_FUNC mtx3354_setGeneralTrigger (ViSession instrumentHandle, ViInt16 triggerSource, 
					ViBoolean slope, ViInt16 coupling, ViBoolean noiseRejection,
                    ViInt16 type, ViReal64 levelvolts, ViReal64 hold);
ViStatus _VI_FUNC mtx3354_setPulsTrigger (ViSession instrSession, ViInt16 pulsType,ViReal64 pulse);
ViStatus _VI_FUNC mtx3354_setDelayedTrigger (ViSession instrSession, ViInt16 auxi_source, ViBoolean edge,
							ViInt16 coupling, ViInt16 noiseReject, ViReal64 level, ViReal64 delay, ViReal64 hold);
ViStatus _VI_FUNC mtx3354_setCountTrigger (ViSession instrSession, ViInt16 auxi_source,
					ViBoolean edge,ViInt16 coupling, ViInt16 noiseReject, ViReal64 level, ViInt32 events, ViReal64 hold);
ViStatus _VI_FUNC mtx3354_setVideoTrigger (ViSession instrSession, ViBoolean standard,
								ViBoolean polarity, ViInt16 line, ViReal64 hold);
ViStatus _VI_FUNC mtx3354_setOptionDisplay (ViSession instrumentHandle, ViBoolean grid,
					ViInt16 device, ViBoolean avanced, ViInt16 language, 
					ViInt16 standby, ViInt16 screen, ViInt16 brightness, ViInt16 contrast);
ViStatus _VI_FUNC mtx3354_setWaveformDisplay (ViSession instrumentHandle, ViInt16 acquisition,
					ViInt16 averagerate, ViInt16 displaymode, ViBoolean repetitive);
ViStatus _VI_FUNC mtx3354_setSPOOptions (ViSession instrumentHandle, ViInt16 Palette, ViInt16 Timing);
ViStatus _VI_FUNC mtx3354_setCursors (ViSession instrumentHandle, ViInt16 cursors, 
					ViInt16 reference, ViBoolean Unattached_cur, ViReal64 t1s, ViReal64 t2s, ViReal64 tphases);
ViStatus _VI_FUNC mtx3354_setHardcopy (ViSession instrumentHandle, ViInt16 device, ViInt16 port, 
					ViString filename, ViBoolean type);
ViStatus _VI_FUNC mtx3354_runAutoset (ViSession instrumentHandle);
ViStatus _VI_FUNC mtx3354_runAcquisition (ViSession instrumentHandle, ViBoolean Run);
ViStatus _VI_FUNC mtx3354_runHardcopy (ViSession instrumentHandle, ViBoolean action);
ViStatus _VI_FUNC mtx3354_readCursors (ViSession instrumentHandle, ViInt16 reference, ViPReal64 t1s,
					ViPReal64 t2s, ViPReal64 dTs, ViPReal64 tphase, ViPReal64 v1v, ViPReal64 v2v, ViPReal64 dVv, ViPReal64 vphase);
ViStatus _VI_FUNC mtx3354_readMeasurement (ViSession instrumentHandle, 
                    ViInt16 measurement, ViInt16 reference, ViPReal64 reading);
ViStatus _VI_FUNC mtx3354_readChToArr (ViSession instrumentHandle, ViInt16 source, ViReal64 _VI_FAR waveformArray[],
                    ViPInt32 numberofsamples, ViPReal64 XStart, ViPReal64 XIncrement ); 
ViStatus _VI_FUNC mtx3354_readChToFile (ViSession instrumentHandle, ViInt16 source,
                    ViInt16 drives, ViString fileName, ViBoolean overwriteFile);
ViStatus _VI_FUNC mtx3354_readFileToArr (ViSession instrumentHandle, ViInt16 drives, ViString fileName,
					ViReal64 _VI_FAR waveformArray[],
					ViPInt32 numberofsamples, ViPReal64 XStart, ViPReal64 XIncrement);
ViStatus _VI_FUNC mtx3354_writeFileToMem (ViSession instrumentHandle, ViString fileName, ViInt16 target);
ViStatus _VI_FUNC mtx3354_saveSetup (ViSession instrumentHandle, ViBoolean mode, ViInt16 drives, ViString fileName,
					ViBoolean overwriteFile);
ViStatus _VI_FUNC mtx3354_fileTransfer (ViSession instrumentHandle, ViString fileName, ViInt16 sourceDrive, 
                    ViBoolean overwriteFile);
ViStatus _VI_FUNC mtx3354_writeInstrData (ViSession instrumentHandle, ViString writeBuffer);
ViStatus _VI_FUNC mtx3354_readInstrData (ViSession instrumentHandle, ViInt32 numberBytesToRead, 
					ViChar _VI_FAR readBuffer[], ViPInt32 numBytesRead);
ViStatus _VI_FUNC mtx3354_reset (ViSession instrumentHandle);
ViStatus _VI_FUNC mtx3354_selfTest (ViSession instrumentHandle, ViPInt16 selfTestResult, ViChar _VI_FAR selfTestMessage[]);
ViStatus _VI_FUNC mtx3354_errorQuery (ViSession instrumentHandle, ViPInt32 errorCode, ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC mtx3354_errorMessage (ViSession instrumentHandle, ViStatus errorCode, ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC mtx3354_revisionQuery (ViSession instrumentHandle, ViChar _VI_FAR instrumentDriverRevision[],
                    ViChar _VI_FAR firmwareRevision[]);
ViStatus _VI_FUNC mtx3354_close (ViSession instrumentHandle);



#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
