s        S   .   	L                                     mtx3354     Metrix MTX3354 DSO 150MS/s (VISA)               ViInt16     ViInt32    ViReal64      ViRsrc     	 	ViBoolean     	 	ViSession      ViStatus       ViChar[]      ViChar      ViString     	  ViInt16[]     	  ViInt32[]     
  	ViReal64[]      	 
ViBoolean[]    ViUInt16    ViUInt32  [    This instrument module provides programming support for the Metrix MTX3354 (VISA).  The module is divided into the following functions:

Functions/Classes:

(1) Initialize:
This function initializes the instrument and sets it to a default configuration.

(2) Application Functions: (Class)
This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

(3) Configuration Functions: (Class)
This class of functions configures the instrument by setting acquisition and system configuration parameters.

(4) Action/Status Functions: (Class)
This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

(5) Data Functions: (Class)
This class of functions transfers data to or from the instrument.

(6) Utility Functions: (Class)
This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

(7) Close:
This function takes the instrument offline.
    $    This class contains high-level, test and measurement routines.  These examples call other instrument driver functions to configure, start, and read from the instrument.

Functions:

(1) Example:
This function configures the MTX3354, runs a Single acquisition, reads and displays a waveform.        This class of functions configures the instrument by setting acquisition and system configuration parameters.

Functions/SubClasses:

(1) Vertical Setup:
Configures various vertical control parameters.

(2) Horizontal: (SubClass)
Configures horizontal control parameters.

(3) Trigger: (SubClass)
Configures the triggering system of the oscilloscope.

(4) Display: (SubClass)
Configures the display parameters.

(5) Hardcopy Setup:
Configures the hardcopy parameters.
         This class of functions configures the horizontal parameters.

Functions:

(1) Horizontal Setup:
Configures the Horizontal Setup parameters.

(2) Horizontal Display:
Configures the Horizontal Display parameters.
(3)FFT
Configures the FFT mode.
          This class of functions configures the triggering of the oscilloscope.


 General Trigger :
Configures the general trigger parameters.

        This class of functions configures the display of the oscilloscope.

Functions:

(1) Options :
Configures the optional display parameters.

(2) Waveform:
Configures the waveform display parameters.

(3) Cursors:
Configures the cursors display parameters.

    ;    This class of functions begins or terminates an acquisition. It also provides functions which allow the user to determine the current status of the instrument.

Functions:

(1) Autoset:
Performs an autoset.

(2) Run/Stop :
Enables or disables the acquisition of input signals.

(3) Hardcopy :
Performs a harcopy.
        This class of functions transfers data to or from the instrument.

Functions:

(1) Read Cursors:
This function reads the cursors positions.

(2) Read Measurements:
This function reads one of the automatic measurement of the oscilloscope.

(3) Waveform:  (Subclass)
This class of functions transfers waveform data to or from the instrument.

(4) Transfer:  (Subclass)
This class of functions transfers files to or from the instrument.
        This class of functions transfer waveform data to or from the instrument.

Functions:

(1) Read Channel to Array:
Reads a trace from the instrument and places it in an array.

(2) Read Channel to File:
Reads a trace from the instrument and places it in a file.

(3) Read File to Array:
Reads a file and places it in an array.

(4) Write File to Memory:
Writes a waveform saved as a file to an instrument display memory.

    >    This class of functions transfer files to or from the instrument.

Functions:

(1) Save/Recall Setup to/from File:
Saves a setup to a file or recalls a setup from a file.

(2) File transfer:
Tranfers any file (.trc or .cfg) from any drive (computer or MTX3354 memory) to any other drive (computer or MTX3354 memory).    X    This class of functions provides lower level functions to communicate with the instrument, and change instrument parameters.

Functions:

(1) Write To Instrument:
This function writes commands and queries to the instrument to modify parameters and query device settings.

(2) Read Instrument Data:
This function reads data from instrument buffer and returns it to the specified variable in memory.

(3) Reset:
This function resets the instrument to its default state.

(4) Self-Test:
This function runs the instrument self test and returns the test code.

(5) Error Query:
This function reads an error code from the instrument error queue.

(6) Error Message:
This function takes the Status Code and returns it as a user readable string.
 
(7) Revision Query:
This function returns the revision numbers of the instrument driver and instrument firmware.

        This function performs the following initialization actions:

- Opens a session to the Default Resource Manager resource and a session to the specified device using the interface and address specified in the Resource_Name control.

- Performs an identification query on the Instrument.

- Resets the instrument to a known state.

- Serial Parameters are: Speed = 115200, Parity = None, Data = 8 bits, Protocol = RTS/CTS (hard)

- Sends initialization commands to the instrument that set any necessary programmatic variables such as Headers Off, Short Command form, and Data Transfer Binary to the state necessary for the operation of the instrument driver.

- Returns an Instrument Handle which is used to differentiate between different sessions of this instrument driver.

- Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control specifies the interface and address of the device that is to be initialized (Instrument Descriptor). The exact grammar to be used in this control is shown in the note below. 

Default Value:  "ASRL1"

Notes:

(1) Based on the Instrument Descriptor, this operation establishes a communication session with a device.  The grammar for the Instrument Descriptor is shown below.  Optional parameters are shown in square brackets ([]).

Interface   Grammar
------------------------------------------------------
Serial      ASRL<port>[::INSTR]
TCPIP       TCPIP[board]::host address::23::SOCKET
USB         USB

The ASRL keyword is used with Serial instruments.

The default value for optional parameters are shown below.

Optional Parameter          Default Value
-----------------------------------------
port                        1 - 32
board                       0
host address                IP address        This control specifies if an ID Query is sent to the instrument during the initialization procedure.

Valid Range:
VI_OFF (0) - Skip Query
VI_ON  (1) - Do Query (Default Value)

Notes:
   
(1) Under normal circumstances the ID Query ensures that the instrument initialized is the type supported by this driver. However circumstances may arise where it is undesirable to send an ID Query to the instrument.  In those cases; set this control to "Skip Query" and this function will initialize the selected interface, without doing an ID Query.    7    This control returns an Instrument Handle that is used in all subsequent function calls to differentiate between different sessions of this instrument driver.

Notes:

(1) Each time this function is invoked a Unique Session is opened.  It is possible to have more than one session open for the same resource.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (ID Query) out of range.
BFFC0003  Parameter 3 (Reset Device) out of range.

BFFC0011  Instrument returned invalid response to ID Query

BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     /    ,    Ressource Name                    Z )        ID Query                           y    }    Instrument Handle                 #      Status                           L 
                                           
                                           
                                            "ASRL1"  ! Do Query VI_ON Skip Query VI_OFF    	           	           pSerial Parameters : 
Speed = 115200
Parity = None
Data = 8 bits
Protocol = RTS/CTS (hard)
ex : "ASRL1" for COM1    eTCPIP Parameters : 
Board = 0
Port = 23
ex : "TCPIP0::192.168.0.10::23:: SOCKET" for IP 192.168.0.10    0USB Parameters : 
ex : "USB" for USB connection   }    This function is an example of this driver's functions use.

The instrument is set to the single shot mode.
User can change the source channel, the timebase, the input voltage range and the input coupling.
A trigger is then sent to the instrument.
The function waits until the acquisition is completed.
Channel is read out from the instrument.
Waveform is interpolated if needed.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Channel) out of range.
BFFC0003  Parameter 3 (Timebase) out of range.
BFFC0004  Parameter 4 (Voltage Range) out of range.
BFFC0005  Parameter 5 (Coupling) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     m    This control selects the source channel.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4     x    This control selects the input coupling of the selected channel.

Valid Values:
0 - AC  (Default Value)
1 - DC
2 - GND        This control selects the main timebase (A) value.

Valid Values: 
0  - 1ns 
1  - 2ns 
2  - 5ns
3  - 10ns  
4  - 20ns 
5  - 50ns
6  - 100ns  
7  - 200ns
8  - 500ns
9  - 1s  
10 - 2s
11 - 5s
12 - 10s  
13 - 20s 
14 - 50s
15 - 100s  
16 - 200s 
17 - 500s 
18 - 1ms  
19 - 2ms  
20 - 5ms 
21 - 10ms   
22 - 20ms 
23 - 50ms 
24 - 100ms   
25 - 200ms  
26 - 500ms 
27 - 1s  
28 - 2s
29 - 5s
30 - 10s  
31 - 20s
32 - 50s        This control sets vertical sense for the specified channel. 

Valid Values:

0  - 2mV/div 
1  - 5mV/div  
2  - 10mV/div           
3  - 20mV/div           
4  - 50mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div           
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  (Default Value)
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            
16 - 500V/div            
17 - 1kV/div              

Note : This control value must be consistent with the probe value. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER7 (0xBFFC0907)


         This control specifies the name of the array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.     R    This control returns the number of valid points read from the selected channel.
     i    This control returns the time of the first data point in seconds (with respect to the trigger point).

     I    This control returns the incrementing value in seconds for the X axis.
    (#      Status                            -h#         Instrument Handle                 . ) G        Source                            .| )  P    Coupling                          . )   P    Time base                         0 )  P    Voltage Range                     3     `    Waveform Array                    4I     `    Number of samples                 4 ,   `    X Start                           5    `    X Increment                        	                          CH1 0 CH2 1 CH3 2 CH4 3              AC 0 DC 1 GND 2           "  100 33 50 S 32 20 S 31 10 s 30 5 S 29 2 S 28 1 S 27 500 mS 26 200 mS 25 100 mS 24 50 mS 23 20 mS 22 10 mS 21 5 mS 20 2 mS 19 1 mS 18 500 S 17 200 S 16 100 S 15 50 S 14 25 S 13 10 S 12 5 S 11 2.5 S 10 1 S 9 500 nS 8 250 nS 7 125 nS 6 50 nS 5 20 nS 4 10 nS 3 5 nS 2 2 nS 1 1 ns 0        	      1 kV 17 500 V 16 200 V 15 100 V 14 50 V 13 20 V 12 10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50 mV 4 20 mV 3 10 mV 2 5 mV 1 2 .5 mV 0    	            	            	           	               This function configures the selected input channel of the instrument.

The following settings are available :
- Channel
- State
- Coupling
- Probe
- Channel inversion
- Range
- Offset
- Bandwidth limitation        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Input) out of range.
BFFC0003  Parameter 3 (State) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (Probe) out of range.
BFFC0006  Parameter 6 (Polarity) out of range.
BFFC0007  Parameter 7 (Volts/div) out of range.
BFFC0008  Parameter 8 (Offset) out of range.

BFFC0803  Error scanning response.
BFFC0809  Parameter 9 (Bandwidth) out of range.

BFFC0900  Instrument specific error.
BFFC0907  Parameter 7 (Volts/div) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     e    This control selects the channel to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
  
     y    This control selects the coupling of the specified channel.

Valid Values: 
0 - AC  
1 - DC  (Default Value)
2 - GND  
         This control selects the probe of the specified channel.

Valid Values: 
1 - x 1  (Default Value)
2 - x 10
3 - x 100 
4 - x 1000 
        This control sets vertical sense for the specified channel. 

Valid Values:

0  - 2.50mV/div 
1  - 5.00mV/div  
2  - 10.0mV/div           
3  - 20.0mV/div           
4  - 50.0mV/div             
5  - 100mV/div          
6  - 200mV/div          
7  - 500mV/div          
8  - 1V/div     (Default Value)      
9  - 2V/div  
10 - 5V/div               
11 - 10V/div  
12 - 20V/div              
13 - 50V/div              
14 - 100V/div             
15 - 200V/div            
16 - 500V/div            
17 - 1kV/div              

Note : This control value must be consistent with the probe value. See the Digiscope 2000 Operating Instructions manual for more details. If it is inconsistent an error is generated : VI_ERROR_INCONSISTENT_PARAMETER7 (0xBFFC0907)


        This control sets the signal offset of the specified channel. 

Valid Ranges:

vertical sense       offset range
2.5mV/div              +/- 80mV
5mV/div              +/- 80mV
10mV/div             +/- 400mV
20mV/div             +/- 400mV
50mV/div             +/- 2V
100mV/div            +/- 2V
200mV/div            +/- 2.5V
500mV/div            +/- 12.5V
1V/div               +/- 12.5V
2V/div               +/- 64V
5V/div               +/- 64V
10V/div              +/- 64V
20V/div              +/- 640V
50V/div              +/- 640V
100V/div             +/- 640V
200V/div             +/- 6400V
500V/div             +/- 6400V
1kV/div              +/- 6400V

Default Value: 0.0
     t    This control selects the state of the specified channel.

Valid Values: 
VI_ON  (1)   (Default Value)
VI_OFF (0) 
     }    This control selects the state of the specified channel.

Valid Values: 
VI_ON  (1) - On  (Default Value)
VI_OFF (0) - Off
    :#      Status                            @6#         Instrument Handle                 @ ) G        Input                             AB )        Coupling                          A )}        Probe                             BO  d  K    Volt/Div                          EN    K    Offset (volts)                    G         Bandwidth                         Hw )         State                              	                          CH1 1 CH2 2 CH3 3 CH4 4              AC 0 DC 1 GND 2                x1 1 x10 10 x100 100 x1000 1000        	      1 kV 17 500 V 16 200 V 15 100 V 14 50 V 13 20 V 12 10 V 11 5 V 10 2 V 9 1 V 8 500 mV 7 200 mV 6 100 mV 5 50.0 mV 4 20.0 mV 3 10.0 mV 2 5 .00mV 1 2.50 mV 0    0.0               'OFF 0 15MHz 15e6 1.5MHz 1.5e6 5kHz 5e3   On VI_ON Off VI_OFF        This function configures the horizontal settings of the instrument.

The following settings are available :

- Pretrigger 
- Range (the main timebase)

    P    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Size) out of range.
BFFC0003  Parameter 3 (Pretrig) out of range.
BFFC0004  Parameter 4 (Delay) out of range.
BFFC0005  Parameter 5 (RangeA) out of range.
BFFC0006  Parameter 6 (DelayA) out of range.
BFFC0007  Parameter 7 (RangeB) out of range.
BFFC0008  Parameter 8 (DelayB) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC0907  Parameter 7 (RangeB) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control selects the main timebase  value.

Valid Values:
0  - 1ns
1  - 2ns 
2  - 5ns
3  - 10ns  
4  - 20ns 
5  - 50ns
6  - 100ns  
7  - 200ns
8  - 500ns - (Default Value)
9  - 1s  
10  - 2s
11 - 5s
12 - 10s  
13 - 20s 
14 - 50s
15 - 100s  
16 - 200s 
17 - 500s 
18 - 1ms  
19 - 2ms  
20 - 5ms 
21 - 10ms   
22 - 20ms 
23 - 50ms 
24 - 100ms   
25- 200ms  
26 - 500ms 
27 - 1s  
28 - 2s
29 - 5s
30 - 10s  
31 - 20s
32 - 50s
33 - 100s
34 - 200s        This control selects the pretrig value ().

Default Value: 0.0
Valid Values are between -10*Range and 25*Range:

Range     Max Values    Min Values      Middle Values 

200s   ->  5000          -2000           -1000
100s   ->  2500          -1000           -500
50s    ->  1250           -500           -250
20s    ->  500           -200            -100
10s    ->  250           -100            -50
5s     ->  125           -50             -25
2s     ->  50            -20             -10
1s     ->  25            -10             -5 
500ms  ->  12500         -5000           -2500
200ms  ->  5000          -2000           -1000
100ms  ->  25*100        -10*100         -500
50ms   ->  25*50         -10*50          -250
20ms   ->  25*20         -10*20          -100
10ms   ->  25*10         -10*10          -50
5ms    ->  25*5          -10*5           -25
2ms    ->  25*2          -10*2           -10
1ms    ->  25*1          -10*1           -5 
500us  ->  25*500        -500*10         -2500
200us  ->  25*200        -10*200         -1000
100us  ->  25*100        -10*100         -500
50us   ->  25*50         -10*50          -250
20us   ->  25*20         -10*20          -100
10us   ->  25*10         -10*10          -50
5us    ->  25*5          -10*5           -25
2us    ->  25*2          -10*2           -10
1us    ->  25*1          -10*1           -5 
500ns  ->  25*500        -500*10         -2500
200ns  ->  25*200        -10*200         -1000
100ns  ->  25*100        -10*100         -500
50ns   ->  25*100        -10*100         -500
20ns   ->  25*100        -10*100         -500
10ns   ->  25*100        -10*100         -500
5ns    ->  25*100        -10*100         -500
2ns    ->  25*100        -10*100         -500
1ns    ->  25*100        -10*100         -500
        L#      Status                            RV#         Instrument Handle                 R L \  P    Range                             T NR  `    Run after delay                    	                      #  (200 S 34 100 S 33 50 S 32 20 S 31 10 s 30 5 s 29 2 s 28 1 s 27 500 ms 26 200 ms 25 100 ms 24 50 ms 23 20 ms 22 10 ms 21 5 ms 20 2 ms 19 1ms 18 500 s 17 200 s 16 100 s 15 50 s 14 25 s 13 10s 12 5 s 11 2.5 s 10 1 s 9 500 ns 8 250 ns 7 125 ns 6 50 ns 5 25 ns 4 10 ns 3 5 ns 2 2 ns 1 1 ns 0    0.0        This function configures the horizontal display of the instrument.
 
The following settings are available :

- Trace 
- X (for XY mode)
- Y (for XY mode)

         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trace) out of range.
BFFC0003  Parameter 3 (X) out of range.
BFFC0004  Parameter 4 (Y) out of range.
BFFC0005  Parameter 5 (Roll) out of range.
BFFC0006  Parameter 6 (Cumul) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     l    This control selects the traces to be displayed.

Valid Values: 
0 - Oscilloscope  (Default Value)
1 - XY
     _    This control selects the X input for XY mode.

Valid Values: 
1 - 1  (Default Value)
2 - 2  
     _    This control selects the Y input for XY mode.

Valid Values: 
1 - 1  (Default Value)
2 - 2  
    ^#         Instrument Handle                 _(#      Status                            c >        Trace                             d^  n        X                                 d         Y                                      	                      Oscilloscope 0 XY 1               1 1 2 2 3 3 4 4               1 1 2 2 3 3 4 4    w    This function configures the FFT mode.

The following settings are available :

- FFT ON or OFF 
- Calculate
- Scale
         This control selects the calculate mode.

Valid Values: 
0 - Rectangular  (Default Value)
1 - Hamming
2 - Hanning  
3 - Blackman         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trigger Source) out of range.
BFFC0003  Parameter 3 (Standard) out of range.
BFFC0004  Parameter 4 (Polarity) out of range.
BFFC0005  Parameter 5 (Field) out of range.
BFFC0006  Parameter 6 (line) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC0906  Parameter 6 (Line) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     v    This control selects the Scale.

Valid Values: 
VI_OFF (0) - Log scale   (Default Value)
VI_ON  (1) - inear scale  
     e    This control valid the FFT mode.

Valid Values: 
VI_OFF (0) - OFF  (Default Value)
VI_ON  (1) - ON
    g%          Calculate                         g#         Instrument Handle                 hN#      Status                            mU p        Scale                             m 5         FFT                                           -Rectangular 0 Hamming 1 Hanning 2 Blackman 3        	         $ Log Scale VI_ON Linear scale VI_OFF    ON VI_ON OFF VI_OFF        This function configures the general trigger parameters of the instrument.

The following settings are available :

- Trigger Source 
- Slope
- Coupling
- Noise Rejection
- Type
- Level

        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Channel) out of range.
BFFC0003  Parameter 3 (Slope) out of range.
BFFC0004  Parameter 4 (Coupling) out of range.
BFFC0005  Parameter 5 (HF Rejection) out of range.
BFFC0006  Parameter 6 (Noise Rejection) out of range.
BFFC0007  Parameter 7 (Type) out of range.
BFFC0008  Parameter 8 (Level) out of range.

BFFC0803  Error scanning response.
BFFC0809  Parameter 9 (Holdoff) out of range.

BFFC0900  Instrument specific error.
BFFC0905  Parameter 5 (HF Rejection) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     ~    This control selects the trigger source to configure.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - External
4 - LINE     |    This control sets the slope of the specified channel.

Valid Values: 
VI_ON  (1) - Up (Default Value)
VI_OFF (0) - Down  
         This control selects the coupling mode of the specified channel.

Valid Values: 
0 - AC (Default Value)
1 - DC  
2 - LF Rej
3 - HF Rej
4 _ TV-Field
5 - TV-line         This control sets the noise rejection of the specified channel.

Valid Values: 
VI_OFF (0) - Off  (Default Value)
VI_ON  (1) - On  
         This control sets level of trigger for the specified channel. 

Valid Range:
-7.5 * vertSense (vertSense in Volts/div)  to  7.5 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
     p    This control selects the type of trigger.

Valid Values: 
0 - Triggered
1 - Auto (Default Value)
2 - Single  
     _    This control sets the holdoff value. 

Valid Range:
40.0 ns to 10.5s

Default Value: 40.0 ns
    p#      Status                            v5#         Instrument Handle                 v ) 9        Trigger Source                    wZ )         Slope                             w )T        Coupling                          x )        Noise Rejection                   y    `    Level (volts)                     y  P        Type                              zR j  `    Holdoff (seconds)                  	                          "CH1 0 CH2 1 CH3 2 CH4 3 Secteur 4   Up VI_ON Down VI_OFF               AC 0 DC 1 LF rej 2 HF rej 3    On VI_ON Off VI_OFF    0.0              Trig'd 0 Auto 1 Single 2    40e-9        This function configures the pulsate trigger mode of the instrument.

The following settings are available :

- Trigger pulsate type
- Pulse
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Window) out of range.
BFFC0004  Parameter 4 (Main Level) out of range.
BFFC0005  Parameter 5 (Auxiliary Level) out of range.

BFFC0903  Parameter 3 (Window) is inconsistent.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     x    This control selects the trigger pulsate type.

Valid Values: 
0 - Equate  (Default Value)
1 - Superior
2 - Inferior 
     d    This control sets the durate  of the pulse. 

Valid Values:
10ns   to  10.5s 
Default Value: 10ns
    ~ #         Instrument Handle                 ~#      Status                             G V        Trigger Pulsate type               =Q  `    Pulse                                  	                      Equate 0 Superior 1 Inferior 2    10E-9        This function configures the delayed trigger parameters of the instrument.

The following settings are available :

- Auxiliary Source 
- Edge
- Coupling
- Noise Rejection
- Level
- Delay
- Holdoff
     o    This control selects the auxilary source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4
     f    This control sets the delay value in seconds.

Valid Range:
20 ns  to  10.5 s

Default Value: 20 ns
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    y    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trigger source) out of range.
BFFC0003  Parameter 3 (Qualifier) out of range.
BFFC0004  Parameter 4 (Delay) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the coupling mode of the specified channel.

Valid Values: 
0 - AC (Default Value)
1 - DC  
2 - LF Rej
3 - HF Rej

         This control sets level of trigger for the specified channel. 

Valid Range:
-7.5 * vertSense (vertSense in Volts/div)  to  7.5 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
     {    This control sets the slope of the specified channel.

Valid Values: 
VI_ON  (1) - Pos (Default Value)
VI_OFF (0) - Neg 
     _    This control sets the holdoff value. 

Valid Range:
40.0 ns to 10.5s

Default Value: 40.0 ns
     t    This control sets the noise rejection of the specified channel.

Valid Values: 
0 - OFF  (Default Value)
3 - ON  
    X - L        Auxiliary Source                       `    Delay                             =#         Instrument Handle                 #      Status                            ] 3        Coupling                            3  `    Level (volts)                      3         Edge                              7   `    Holdoff (seconds)                  1        Noise Rejection                               CH1 1 CH2 2 CH3 3 CH4 4    20E-9        	                      AC 0 DC 1 LF rej 2 HF rej 3    0.0   Pos VI_ON Neg VI_OFF    40e-9               ON 3 OFF 0        This function configures the count trigger parameters of the instrument.

The following settings are available :

- Auxiliary Source 
- Edge
- Coupling
- Noise Rejection
- Level
- Events
- Holdoff
     p    This control selects the counter source.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2
3 - CH3  
4 - CH4


     `    This control sets the number of events to count.

Valid Range:
3 to 16 384 

Default Value: 3
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trigger source) out of range.
BFFC0003  Parameter 3 (Qualifier) out of range.
BFFC0004  Parameter 4 (Counter) out of range.
BFFC0005  Parameter 5 (Events) out of range.

BFFC0905  Parameter 5 (Events) is inconsistent.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     |    This control sets the slope of the specified channel.

Valid Values: 
VI_ON  (1) - Pos (Default Value)
VI_OFF (0) - Neg  
         This control selects the coupling mode of the specified channel.

Valid Values: 
0 - AC (Default Value)
1 - DC  
2 - LF Rej
3 - HF Rej

         This control sets level of trigger for the specified channel. 

Valid Range:
-7.5 * vertSense (vertSense in Volts/div)  to  7.5 * vertSense (vertSense in Volts/div)

Default Value: 0.0 V
     ]    This control sets the holdoff value. 

Valid Range:
40.0 ns to 30s

Default Value: 60.0 ns
     t    This control sets the noise rejection of the specified channel.

Valid Values: 
0 - OFF  (Default Value)
3 - ON  
    s * D        Auxiliary Source                      `    Events                            S#         Instrument Handle                 #      Status                             .         Edge                              V -        Coupling                              `    Level (volts)                        `    Holdoff (seconds)                  2        Noise Rejection                               CH1 1 CH2 2 CH3 3 CH4 4    3        	          Pos VI_ON Neg VI_OFF               AC 0 DC 1 LF rej 2 HF rej 3    0.0    40e-9              ON 3 OFF 0        This function configures the video trigger mode of the instrument.

The following settings are available :

- Standard
- Polarity
- Line
- Holdoff     A    This control selects the number of the line.

Default Value: 1
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Trigger Source) out of range.
BFFC0003  Parameter 3 (Standard) out of range.
BFFC0004  Parameter 4 (Polarity) out of range.
BFFC0005  Parameter 5 (Field) out of range.
BFFC0006  Parameter 6 (line) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC0906  Parameter 6 (Line) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     j    This control selects the standard.

Valid Values: 
VI_OFF (0) - 525  
VI_ON  (1) - 625  (Default Value)
     p    This control selects the polarity.

Valid Values: 
VI_OFF (0) - Pos (+)  (Default Value)
VI_ON  (1) - Neg (-)
     ]    This control sets the holdoff value. 

Valid Range:
40.0 ns to 30s

Default Value: 60.0 ns
      b  `    Line                              #         Instrument Handle                 #      Status                             + [        Standard                           )        Polarity                           f  `    Holdoff (seconds)                  1        	          625 VI_ON 525 VI_OFF    Neg (-) VI_ON Pos (+) VI_OFF    40e-9        This function configures the display options of the instrument.

The following settings are available :

- Grid 
- Divice Mode
- Advanced mode
- Language
- Standby
- Screen
- Brightness
- Contrast
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Grid) out of range.
BFFC0003  Parameter 3 (Color) out of range.
BFFC0004  Parameter 4 (Screen) out of range.
BFFC0005  Parameter 5 (Menus) out of range.
BFFC0006  Parameter 6 (Language) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     k    This control sets the grid display.

Valid Values: 
VI_OFF (0) - Off  
VI_ON  (1) - On   (Default Value)
     s    This control selects the principal mode.

Valid Values: 
0 - Scope   (Default Value)
1 - Analyser
2 - Recorder            This control selects the language used on the instrument.

Valid Values:

0 - English
1 - French  (Default Value) 
2 - German   
3 - Spanish
4 - Italiano     p    This control sets the sceen saver values.

Valid Values: 
0 - none
1 - 15min
2 - 30min
3 - 1H  (Default Value)     t    This control sets the advanced mode display.

Valid Values: 
VI_OFF (0) - Off  
VI_ON  (1) - On   (Default Value)
     k    This control sets the standby values.

Valid Values: 
0 - 30min
1 - 1H
2 - 4H
3 - 24H  (Default Value)
 
     H    This control sets level of the brightness. 

Valid values:
0 to 100%

     C    This control sets level of the contrast.

Valid values:
0 to 100%    Q#      Status                            #         Instrument Handle                  0         Grid                              1 2         Device Mode                        2        Language                          O          Screen _Saver                      3+        Advanced_Mode                     C  3        Standby                              `    Brightness (%)                       `    Contrast (%)                       	              On VI_ON Off VI_OFF               +Oscilloscope 0 Analyser 1 Recorder 2 SPO 3              1English 0 French 1 German 2 Spanish 3 Italiano 4              none 0 15min 1 30min 2 1H 3   On VI_ON Off VI_OFF              30min 0 1H 1 4H 2 24H 3    100    74        This function configures the waveform display of the instrument.

The following settings are available :

- Min/Max acquisition
- Average rate
- Mode 
- Repetitive Signal
     u    This control sets the average rate.

Valid Values: 
0 - No averaging (Default Value)
1 - 2  
2 - 4
3 - 16  
4 - 64
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Average rate) out of range.
BFFC0004  Parameter 4 (Persistence) out of range.
BFFC0005  Parameter 5 (Interpolation) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     f    This control selects the display mode.

Valid Values: 
0 - Vector   (Default Value)
1 - Envelope
        s    This control selects the repetitive signal.

Valid Values: 
VI_OFF (0) - Off  
VI_ON  (1) - On   (Default Value)
     s    This control Valids the Min/Max Acquisition.

Valid Values: 
0 - Normal_OFF   (Default Value)
1 - Envelope_ ON


    / H  Z    Average rate                      #         Instrument Handle                 K#      Status                             5        Display Mode                      l          Repetitive Signal                  >         Min-Max                                      !64 4 16 3 4 2 2 1 No averaging 0        	                     Vector 0 Envelope 1   On VI_ON Off VI_OFF              ON 0 OFF 1        This function configures the waveform display of the instrument.

The following settings are available :

- Min/Max acquisition
- Average rate
- Mode 
- Repetitive Signal
         This control sets the timimg of persistance.

Valid Values: 
0 - 100ms
1 - 200ms
3 - 500ms (Default Value)
4 - 1s
5 - 2s
6 - 5s  
7 - 10s  
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Average rate) out of range.
BFFC0004  Parameter 4 (Persistence) out of range.
BFFC0005  Parameter 5 (Interpolation) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     m    This control sets the palette of colors.

Valid Values: 
0 - Monochrome   (Default Value)
1 - Multicolor


     H  Z    Timing                            #         Instrument Handle                 #      Status                             >         Palette                                      8100ms 0 200ms 1 500ms 2 1s 3 2s 4 5s 5 10s 6 Infinite 7        	                      Monochrome 0 Multicolor 1        This function sets horizontal cursors.

The following settings are available :

- Cursors 
- Reference
- Unattached cursors 
- T1
- T2
- TPhase
     W    This control selects the reference.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Clear Cursors) out of range.
BFFC0003  Parameter 3 (Reference) out of range.
BFFC0004  Parameter 4 (T1) out of range.
BFFC0005  Parameter 5 (T2) out of range.
BFFC0006  Parameter 6 (V1) out of range.
BFFC0007  Parameter 7 (V2) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     v    This control sets the position of the vertical cursor #1.

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

     ~    This control sets the position of the vertical cursor #3 (phase).

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

     h    This control selects the cursors mode.

Valid Values: 
0 - OFF  (Default Value)
1 - ON
2 - ON+PHASE  
     v    This control sets the position of the vertical cursor #2.

Valid Range:
+/- 100 * horizSense (horizSense in s/div)

     t    This control selects the unattached cursors.

Valid Values: 
VI_OFF (0) - Off  
VI_ON  (1) - On   (Default Value)
    4 )         Reference                         Ǔ#         Instrument Handle                 2#      Status                            (    `    T1 (s)                            ͦ =   `    Tphase(s)                         , - [        Cursors                           Μ     `    T2 (s)                             +        Unattached cursors                            CH1 0 CH2 1 CH3 2 CH4 3        	           250E-3    250E-3               OFF 0 ON 1 ON+PHASE 2    500E-3   On VI_ON Off VI_OFF    |    This function sets hardcopy parameters.

The following settings are available :

- Device 
- Port
- Filename 
- Color type         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    `    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Device) out of range.
BFFC0003  Parameter 3 (Port) out of range.
BFFC0004  Parameter 4 (Filename) out of range.
BFFC0005  Parameter 5 (Type) out of range.
BFFC0006  Parameter 6 (# of pages) out of range.
BFFC0007  Parameter 7 (Page Number) out of range.
BFFC0008  Parameter 8 (# of pens) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC0906  Parameter 6 (# of pages) is inconsistent.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control selects the device language.

Valid Values: 
0  - IBM Proprinter (Default Value)
1  - EPSON ESC/P2
2  - Canon 
3  - HP-PCL
4  - Seiko 
5  - Postscript
6  - bitmap BMP
7  - GIF         This control selects the measurement to display.

Valid Values: 
0  - RS232 (Default Value)
1  - Centronics
2  - Network
3  - File         This control sets the filename where to store the hardcopy.

Default Value: ""

Note : It must be an 8-character name with no extension. Extension is automatically added according to the device language. See the Digiscope 2000 Operating Instructions manual for more details.     v    This control sets the color of pages.

Valid Values:
VI_OFF (0) - Black & White (Default Value) 
VI_ON  (1) - Color
    S#         Instrument Handle                 #      Status                            Z =       Device                              =       Port                              ٭ =   `    Filename                                    Type                                   	                      [IBM Proprinter 0 Epson ESC/P2 1 Canon 2 HP PCL 3 Seiko  4 Postscript 5 bitmap BMP  6 GIF 7               'RS232 0 Centronics 1 Network 2 File  3    ""  ! Color VI_ON Black & White VI_OFF    6    This function performs an autoset of the instrument.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090F  No channel is enabled.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    ݝ#      Status                            #         Instrument Handle                  	               D    This function controls the acquisition system of the instrument. 
    >    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Wait?) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control valid the acquisition system of the instrument. 

Valid Values:
VI_OFF (0) - Stop 
VI_ON  (1) - Run   (Default Value)

    #      Status                            X#         Instrument Handle                  Y         Acquisition                        	              Run VI_ON Stop VI_OFF    ?    This function controls the hardcopy system of the instrument.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Action) out of range.

BFFC0803  Error scanning response

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None         This control selects whether to run the hardcopy or to abort it. 

Valid Values:
VI_OFF (0) - Abort  
VI_ON  (1) - Run     (Default Value)
    #      Status                            #         Instrument Handle                 ) 3        Action                             	               Run VI_ON Abort VI_OFF    Z    This function reads cursors positions.
All measured quantities are in their basic units.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    
    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Reference) out of range.
BFFC0003  Parameter 3 (T1) out of range.
BFFC0004  Parameter 4 (T2) out of range.
BFFC0005  Parameter 5 (dT) out of range.
BFFC0006  Parameter 6 (V1) out of range.
BFFC0007  Parameter 7 (V2) out of range.
BFFC0008  Parameter 8 (dV) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     |    This control selects the reference channel for the cursors positions.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
  
     ?    This control outputs the position of the vertical cursor #1.
     ?    This control outputs the position of the vertical cursor #2.
     ?    This control outpus the difference between vertical cursors.
     @    This control outpus the position of the horizontal cursor #1.
     ?    This control outpus the position of the horizontal cursor #2.     A    This control outpus the difference between horizontal cursors.
     ?    This control outpus the difference between vertical cursors.
     A    This control outpus the difference between horizontal cursors.
    #         Instrument Handle                 #      Status                              9        Reference                         !     `    T1 (s)                            h b    `    T2 (s)                                 `    dT (s)                             \   `    V1 (V)                            > b\   `    V2 (V)                             Y   `    dV (V)                                 `    Tphase (s)                         \ 	  `    Vphase (V)                             	                      CH1 0 CH2 1 CH3 2 CH4 3    	           	           	           	           	           	           	           	               This function forces the instrument to perform selected measurement and returns the result.
All measured quantities are in their basic units.         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    w    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Measurement) out of range.
BFFC0003  Parameter 3 (Reference) out of range.
BFFC0004  Parameter 4 (Reading) out of range.

BFFC0803  Error scanning response

BFFC0900  Instrument specific error.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     }    This control selects the reference channel for the specified measurement.

Valid Values: 
0 - CH1  (Default Value)
1 - CH2
     n    This control outputs the result of the measurement.
All measured quantities are output in their basic units.    j    This control specifies the measurement function.

Valid Values: 
0  - Minimum Voltage     [V]  
1  - Maximum Voltage     [V]
2  - Peak to Peak        [V] (Default Value)
3  - Low Voltage         [V]  
4  - High Voltage        [V]
5  - Amplitude           [V]    
6  - Voltage RMS Voltage [V]
7  - Average Voltage     [V] 
8  - Rise Overshoot      [%]
9  - Fall Overshoot      [%] 
10 - Rise Time           [s] 
11 - Fall Time           [s]
12 - Pos Pulse Width     [s]
13 - Neg Pulse Width     [s]
14 - Period               [s] 
15 - Frequency           [Hz]
16 - Dutycycle           [%]
17 - N
18 _ Phase               #         Instrument Handle                 r#      Status                             G        Reference                        v Gz   `    Reading                           G 4  x    Measurement                            	                      CH1 0 CH2 1 CH3 2 CH4 3    	                    Minimun Voltage 0 Maximun  Voltage 1 Peak To Peak 2 Low Voltage 3 High Voltage 4 Amplitude 5 RMS Voltage(AC) 6 Average Voltage 7 Rise Overshoot 8 FuallOvershoot 9 Rise Time 10 Fall Time 11 Pos Pulse Width 12 Neg Pulse Width 13 Period 14 Freqency 15 Duty Cycle 16 N 17 Phase 18    [    This function reads the specified channel from the instrument and places it in an array.
     ]    This control selects the source channel.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2

         This function specifies the name of array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.His numberr of elements is 50000.
     S    This function returns the number of valid points read from the selected channel.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Interpolation) out of range.

BFFC0803  Error scanning response.

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     j    This function returns the time of the first data point in seconds (with respect to the trigger point).

     J    This function returns the incrementing value in seconds for the X axis.
   1 3        Source                                 `    Waveform Array                   _     `    Number of samples                #         Instrument Handle                	Y#      Status                           
 +   `    X Start                          ]    `    X Increment                                   CH1 0 CH2 1 CH3 2 CH4 3    	            	                	           	           	           M    This function reads a channel from the instrument and stores it as a file.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Source) out of range.
BFFC0003  Parameter 3 (Drive) out of range.
BFFC0004  Parameter 4 (Filename) out of specifications.
BFFC0005  Parameter 5 (Overwrite File?) out of range.

BFFC0801  Error writing to file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090C  Channel is not active.
BFFC090E  File already exists.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
        This function specifies the name of the wave data file.

Default Value: ""

Notes:

(1) When storing a file to Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 15-character long max plus ".TRC" extension.The extention must be in capital letter.
If not, an error is generated :0xBFFC0004 

(3) If the target file already exists and overwrite is not selected, an error is generated : 0xBFFC090E

     \    This control selects the destination drive.

Valid Values:
0 - Computer
1 - MTX3x52 Memory         This function specifies whether or not to write over the specified file if it already exists.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
     ]    This control selects the source channel.

Valid Values: 
1 - CH1  (Default Value)
2 - CH2

   #         Instrument Handle                }#      Status                                    File Name                                  Drives                                    Overwrite File?                   +        Source                                 	           ""               Computer 0 MTX3x52 Memory 1    Yes VI_ON No VI_OFF               CH1 0 CH2 1 CH3 2 CH4 3    N    This function reads a stored waveform file and places the data in an array.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Drive) out of range.
BFFC0003  Parameter 3 (Filename) out of specifications.
BFFC0004  Parameter 4 (Interpolation) out of range.

BFFC0800  Error opening file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.     X    This control selects the source drive.

Valid Values:
0 - Computer
1 - MTX3x52 Memory
        This function specifies the name of the wave data file.

Default Value: ""

Notes:

(1) When reading a file from Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 15-character long max + ".TRC" extension.
The extention must be in capital letter.
If not an error is generated :0xBFFC0003  

(3) If file does not exist an error is generated : 0xBFFC090D



         This function specifies the name of array in which to place the waveform data.

Notes:

(1) The Real Array must be large enough to hold the requested points.His numberr of elements is 50000.     P    This function returns the number of valid points read from the selected file.
     j    This function returns the time of the first data point in seconds (with respect to the trigger point).

     J    This function returns the incrementing value in seconds for the X axis.
   4#         Instrument Handle                #      Status                           ! 3         Drives                           " 3&       File Name                        $     `    Waveform Array                   $     `    Number of samples                %# .   `    X Start                          %    `    X Increment                            	                      Computer 0 MTX3354 Memory 1    ""    	            	            	           	           g    This function writes a wave data file (in the memory oscilloscope) to the instrument display memory.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Drive) out of range.
BFFC0003  Parameter 3 (Filename) out of specifications.
BFFC0004  Parameter 4 (Overwrite File?) out of range.

BFFC0800  Error opening file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     h    This control selects the target memory.

Valid Values: 
1 - M1  (Default Value)
2 - M2
3 - M3  
4 - M4        This control selects the target memory.

Default Value: ""

Notes:

(1) File name must be 8-character long max + ".TRC" extension. The extention must be in capital letter.

If not an error is generated :0xBFFC0003  

(2) If file does not exist an error is generated : 0xBFFC090D

   (o#         Instrument Handle                )#      Status                           -         Target                           ._ *        File Name                              	                      M1 1 M2 2 M3 3 M4 4    ""    7    This function save or recall set-up to or from file.
    D    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Mode) out of range.
BFFC0003  Parameter 3 (Drive) out of range.
BFFC0004  Parameter 4 (Filename) out of specifications.
BFFC0005  Parameter 5 (Overwrite File?) out of range.

BFFC0800  Error opening file.
BFFC0801  Error writing to file.
BFFC0803  Error Scanning Response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC090E  File already exists.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None     r    This control selects the target/source drive.

Valid Values:
0 - Computer  
1 - MTX3x52 Memory  (Default Value)
        This function specifies the name of the setup data file.

Default Value: ""

Notes:

(1) When reading/writing a file from/to Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 8-character long max + ".CFG" extension.
The extention must be in capital letter.

If not an error is generated :0xBFFC0004  

(3) When saving a setup : if the target file already exists and overwrite is not selected an error is generated : 0xBFFC090E

(4) When recalling a setup : if file does not exist an error is generated : 0xBFFC090D

         This function specifies whether or not to write over the specified file if it already exists on disk.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
     |    This control selects between Save and Recall mode.

Valid Range:  
VI_OFF (0) - Recall
VI_ON  (1) - Save  (Default Value)
   0#      Status                           6#         Instrument Handle                6          Drives                           72         File Name                        9         Overwrite File?                  :w )        Mode                               	                         Computer 0 MTX3354 Memory 1    ""    Yes VI_ON No VI_OFF   Save VI_ON Recall VI_OFF    ,    This function performs a file transfer.


         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None    S    This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFC0002  Parameter 2 (Filename) out of specifications.
BFFC0003  Parameter 3 (Source Drive) out of range.
BFFC0004  Parameter 4 (Overwrite File?) out of range.
BFFC0005  Parameter 5 (Target Drive) out of range.

BFFC0800  Error opening file.
BFFC0801  Error writing to file.
BFFC0803  Error scanning response

BFFC0900  Instrument specific error.
BFFC090D  File not found.
BFFC090E  File already exists.
BFFC0910  Invalid file content.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
     i    This control selects the source drive.

Valid Values:
0 - Computer  (Default Value)
1 - MTX3x52 Memory
    k    This function specifies the name of the data file.

Default Value: ""

Notes:

(1) When reading a file from Computer, precede all backslashes with an additional backslash, e.g. if the file is in the \cvi\instr directory, enter the filename as "\\cvi\\instr\\anyfile".

(2) File name must be 15-character long max + ".???" extension.
The extention must be in capital letter.

If not an error is generated :0xBFFC0002  

(3) If the file already exists on the target drive and overwrite is not selected an error is generated : 0xBFFC090E

(4) If file does not exist on the source drive an error is generated : 0xBFFC090D         This function specifies whether or not to write over the specified file if it already exists on disk.

Valid Range:  
VI_OFF (0) - No  (Default Value)
VI_ON  (1) - Yes
   <#         Instrument Handle                =#      Status                           B          Source Drive                     CL +        File Name                        E         Overwrite File?                        	                      Computer 0 MTX3354 Memory 1    ""    Yes VI_ON No VI_OFF    m    This function writes commands and queries to the instrument to modify parameters and query device settings.    z    The user can use this control to send common commands and queries to the instrument. This control can also be used to write any valid command to the instrument.

Default Value:  "*CLS\r"

Notes:

(1) The command or query to be sent to the instrument may be a literal enclosed in double quotes terminated by '\r' i.e. "*CLS\r" or may be contained in a variable of type string.
        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   HG M E      Write Buffer                     I#      Status                           Mn#         Instrument Handle                  	"*CLS\r"    	              7    This function reads data from the instrument's output buffer and returns it to the specified variable in memory.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) If valid data is not available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled this function will hang indefinitely and it may be necessary to reboot the computer to break out.        The number of bytes specified by this control should be greater than or equal to the number of bytes which are to be read from the instrument. If the actual number of bytes to be read is greater than the number this control specifies then multiple reads will be required to empty the instrument's output buffer.

If the instrument's output buffer is not emptied the instrument may return invalid data when future reads are performed.

Default Value:  50 (See NOTE 2)

Notes:

(1) If NO DATA is available at the instrument's output buffer when this function is called the instrument will hang up and the function will not return until it times out.  If the time-out is disabled, this function will hang indefinitely and it may be necessary to reboot the computer.

(2) If the number of bytes expected is greater than 50 the value of this control may be increased. If the actual number of bytes read is larger than the declared size of the read buffer a run-time error will be generated.
        The incoming data from the instrument is placed into this variable.

Notes:

(1) Because the instrument may return both numeric and text data in response to queries this function returns the data in string format.

(2) This function does not overwrite any old data left in the string variable from the last time the function was called. String data in LabWindows/CVI is terminated with an ASCII null(0x0) and string manipulation functions will only recognize data before the ASCII null.

(3) The declared size of the string variable must be greater than the actual number of bytes read from the instrument if it is not a run-time error will be generated.
        This variable contains the actual number of bytes read from the instrument. This is the value which is returned by the read function.

Notes:

(1) If the actual number of bytes read is less than the number of bytes specified in the Number Bytes To Read control then the output buffer has probably been emptied. If the read function fails and the number of bytes read is 0, the most probable cause for the failure is there was no data available at the instrument's output buffer.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   Q M K   `    Number Bytes To Read             T  H      Read Buffer                      W Mx   `    NumBytes Read                    Yl#      Status                           ]#         Instrument Handle                  50    	            	            	               ~    This function resets the instrument to a known state.
See the Digiscope 2000 Operating Instructions manual for more details.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   _m#      Status                           c#         Instrument Handle                  	               W    This function runs the instrument's self test routine and returns the test result(s).         This control contains the value returned from the instrument self test.  Zero means success.  For any other code, see the device's operator's manual.
         This control contains the string returned from the self test. See the device's operation manual for an explanation of the string's contents.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0803  Error scanning response.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   d = 2   `    Self Test Result                 e* =   ,    Self-Test Message                f#      Status                           i#         Instrument Handle                  	           	            	               H    This function reads an error code from the instrument's error queue.

     N    This control returns the error code read from the instrument's error queue.
         This control returns the error message string read from the instrument's error message queue.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   k = 2   `    Error Code                       l =   ,    Error Message                    l#      Status                           pd#         Instrument Handle                  	            	            	                   This function takes the Status Code returned by the instrument driver functions, interprets it and returns it as a user readable string.      t    This control accepts the Status Code returned from the instrument driver functions.

Default Value:
0 - VI_SUCCESS         This control returns the interpreted Status Code as a user readable message string.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.
3FFF0085  Unknown status.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  VI_NULL   r =    `    Error Code                       s =       Error Message                    s#      Status                           wq#         Instrument Handle                  0    	            	           VI_NULL   0    This function returns the revision numbers of the instrument driver and instrument firmware, and tells the user what firmware the driver is compatible with, for example:

This instrument driver's Revision Number is "Rev 1.0, 04/2005, CVI 6.0" and is compatible with Instrument Firmware Revision "1.6".
         This control returns the Instrument Driver Software Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].         This control returns the Instrument Firmware Revision.

Notes:

(1) The array must contain at least 256 elements ViChar[256].        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   zG = 2       Instrument Driver Revision       z =,       Firmware Revision                {\#      Status                           #         Instrument Handle                  	            	            	                   This function performs the following operations:
viClose (instrSession) and viClose (rmSession).

Notes:

(1) The instrument must be reinitialized to use it again.        This control contains the status code returned by the function call.

Status Codes:

Status    Description
-------------------------------------------------
       0  No error (the call was successful).

3FFF0005  The specified termination character was read.
3FFF0006  The specified number of bytes was read.

BFFF0000  Miscellaneous or system error occurred.
BFFF000E  Invalid session handle.
BFFF0015  Timeout occurred before operation could complete.
BFFF0034  Violation of raw write protocol occurred.
BFFF0035  Violation of raw read protocol occurred.
BFFF0036  Device reported an output protocol error.
BFFF0037  Device reported an input protocol error.
BFFF0038  Bus error occurred during transfer.
BFFF003A  Invalid setup (attributes are not consistent).
BFFF005F  No listeners condition was detected.
BFFF0060  This interface is not the controller in charge.
BFFF0067  Operation is not supported on this session.
         This control accepts the Instrument Handle returned by the Initialize function to select the desired instrument driver session.

Default Value:  None   I#      Status                           #         Instrument Handle                  	                       $K     K*    init                                     '  5e 
    K.    example                                  9  H 	    K.    verticalSetup                            L\  [     K.    horizontalSetup                          ]  e,     K.    horizontalDisplay                        f  n@     K.    FFT                                      o  z 	    K.    setGeneralTrigger                        }i  m     K.    setPulsTrigger                              	    K.    setDelayedTrigger                           	    K.    setCountTrigger                                 K.    setVideoTrigger                            Q 
    K.    setOptionDisplay                         z  b     K.    setWaveformDisplay                       4  F     K.    setSPOOptions                            ƚ  ϖ     K.    setCursors                                 G     K.    setHardcopy                              _  L     K.    runAutoset                                      K.    runAcquisition                           M       K.    runHardcopy                                ^     K.    readCursors                              < ^     K.    readMeasurement                               K.    readChToArr                              !     K.    readChToFile                             %     K.    readFileToArr                           (  /     K.    writeFileToMem                          0 :     K.    saveSetup                               < Fq     K.    fileTransfer                            G N
     K.    writeInstrData                          N ]     K.    readInstrData                           ^ c     K.    reset                                   d+ jo     K.    selfTest                                kk q     K.    errorQuery                              q x     K.    errorMessage                            y      K.    revisionQuery                                 K.    close                                                                      DInitialize                          &Application Functions                DExample                             RConfigure Functions                  DVertical Setup                      	0Horizontal                           DHorizontal Setup                     DHorizontal Display                   DFFT                                 
/Trigger                              DGeneral Trigger                      DPulse Trigger                        DDelayed Trigger                      DCount Trigger                        DVideo Trigger                       
Display                              DOptions                              DWaveform                             DSPO Mode                             DCursors                              DHardcopy Setup                      Action/Status Functions              DAutoset                              DRun/Stop                             DHardcopy                            
Data                                 DRead Cursors                         DRead Measurements                   Waveform                             DRead Channel To Array                DRead Channel To File                 DRead File To Array                   DWrite File To Memory                yTransfer                             DSave/Recall Setup To/From File       DFile Transfer                       Utility Functions                    DWrite To Instrument                  DRead Instrument Data                 DReset                                DSelf-Test                            DError-Query                          DError Message                        DRevision Query                       DClose                           